/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileCalculationMethod;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileResult;

public final class ExponentiallyWeightedInterpolationQuantileMethod
extends QuantileCalculationMethod {
    private final double lambda;

    public ExponentiallyWeightedInterpolationQuantileMethod(double lambda) {
        ArgChecker.inRangeExclusive((double)lambda, (double)0.0, (double)1.0, (String)"exponential weight");
        this.lambda = lambda;
    }

    @Override
    public QuantileResult quantileResultFromUnsorted(double level, DoubleArray sample) {
        return this.quantileDetails(level, sample, false, false);
    }

    @Override
    public QuantileResult quantileResultWithExtrapolationFromUnsorted(double level, DoubleArray sample) {
        return this.quantileDetails(level, sample, true, false);
    }

    @Override
    public double quantileFromUnsorted(double level, DoubleArray sample) {
        return this.quantileResultFromUnsorted(level, sample).getValue();
    }

    @Override
    public double quantileWithExtrapolationFromUnsorted(double level, DoubleArray sample) {
        return this.quantileResultWithExtrapolationFromUnsorted(level, sample).getValue();
    }

    @Override
    public QuantileResult expectedShortfallResultFromUnsorted(double level, DoubleArray sample) {
        return this.quantileDetails(level, sample, true, true);
    }

    @Override
    public double expectedShortfallFromUnsorted(double level, DoubleArray sample) {
        return this.expectedShortfallResultFromUnsorted(level, sample).getValue();
    }

    public QuantileResult quantileDetailsFromUnsorted(double level, DoubleArray sample) {
        return this.quantileDetails(level, sample, true, false);
    }

    public QuantileResult expectedShortfallDetailsFromUnsorted(double level, DoubleArray sample) {
        return this.quantileDetails(level, sample, true, true);
    }

    private QuantileResult quantileDetails(double level, DoubleArray sample, boolean isExtrapolated, boolean isEs) {
        double runningWeight;
        int nbData = sample.size();
        double[] w = this.weights(nbData);
        double[] s = sample.toArray();
        DoubleArrayMath.sortPairs((double[])s, (double[])w);
        double[] s2 = sample.toArray();
        double[] order = new double[s2.length];
        for (int i = 0; i < s2.length; ++i) {
            order[i] = i;
        }
        DoubleArrayMath.sortPairs((double[])s2, (double[])order);
        int index = nbData;
        for (runningWeight = 0.0; runningWeight < 1.0 - level; runningWeight += w[--index]) {
        }
        if (isEs) {
            return this.esFromIndexRunningWeight(index, runningWeight, s2, w, order, level);
        }
        return this.quantileFromIndexRunningWeight(index, runningWeight, isExtrapolated, s2, w, order, level);
    }

    private QuantileResult quantileFromIndexRunningWeight(int index, double runningWeight, boolean isExtrapolated, double[] s, double[] w, double[] order, double level) {
        int nbData = s.length;
        if (index == nbData - 1 || index == nbData) {
            ArgChecker.isTrue((boolean)isExtrapolated, (String)"Quantile can not be computed above the highest probability level.");
            return QuantileResult.of(s[nbData - 1], new int[]{(int)Math.round(order[nbData - 1])}, DoubleArray.of((double)1.0));
        }
        double alpha = (runningWeight - (1.0 - level)) / w[index];
        int[] indices = new int[nbData - index];
        double[] impacts = new double[nbData - index];
        for (int i = 0; i < nbData - index; ++i) {
            indices[i] = (int)Math.round(order[index + i]);
        }
        impacts[0] = 1.0 - alpha;
        impacts[1] = alpha;
        return QuantileResult.of((1.0 - alpha) * s[index] + alpha * s[index + 1], indices, DoubleArray.ofUnsafe((double[])impacts));
    }

    private QuantileResult esFromIndexRunningWeight(int index, double runningWeight, double[] s, double[] w, double[] order, double level) {
        int i;
        int nbData = s.length;
        if (index == nbData - 1 || index == nbData) {
            return QuantileResult.of(s[nbData - 1], new int[]{(int)Math.round(order[nbData - 1])}, DoubleArray.of((double)1.0));
        }
        double alpha = (runningWeight - (1.0 - level)) / w[index];
        int[] indices = new int[nbData - index];
        double[] impacts = new double[nbData - index];
        for (i = 0; i < nbData - index; ++i) {
            indices[i] = (int)Math.round(order[index + i]);
        }
        impacts[0] = 0.5 * (1.0 - alpha) * (1.0 - alpha) * w[index] / (1.0 - level);
        impacts[1] = (alpha + 1.0) * 0.5 * (1.0 - alpha) * w[index] / (1.0 - level);
        for (i = 1; i < nbData - index - 1; ++i) {
            int n = i;
            impacts[n] = impacts[n] + 0.5 * w[index + i] / (1.0 - level);
            int n2 = i + 1;
            impacts[n2] = impacts[n2] + 0.5 * w[index + i] / (1.0 - level);
        }
        int n = nbData - index - 1;
        impacts[n] = impacts[n] + w[nbData - 1] / (1.0 - level);
        double es = 0.0;
        for (int i2 = 0; i2 < nbData - index; ++i2) {
            es += s[index + i2] * impacts[i2];
        }
        return QuantileResult.of(es, indices, DoubleArray.ofUnsafe((double[])impacts));
    }

    @Override
    protected QuantileResult quantile(double level, DoubleArray sortedSample, boolean isExtrapolated) {
        throw new UnsupportedOperationException("Quantile available only from unsorted sample due to weights.");
    }

    @Override
    protected QuantileResult expectedShortfall(double level, DoubleArray sortedSample) {
        throw new UnsupportedOperationException("Expected Shortfall only from unsorted sample due to weights.");
    }

    public double[] weights(int size) {
        double w1 = (1.0 - 1.0 / this.lambda) / (1.0 - Math.pow(this.lambda, -size));
        double[] w = new double[size];
        for (int i = 0; i < size; ++i) {
            w[i] = w1 / Math.pow(this.lambda, i);
        }
        return w;
    }
}

