/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.descriptive.MeanCalculator;
import java.util.function.Function;

public class SampleSkewnessCalculator
implements Function<double[], Double> {
    private static final Function<double[], Double> MEAN = new MeanCalculator();

    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length >= 3 ? 1 : 0) != 0, (String)"Need at least three points to calculate sample skewness");
        double sum = 0.0;
        double variance = 0.0;
        double mean = MEAN.apply(x);
        for (double d : x) {
            double diff = d - mean;
            variance += diff * diff;
            sum += diff * diff * diff;
        }
        int n = x.length;
        return Math.sqrt((double)n - 1.0) * sum / (Math.pow(variance /= (double)(n - 1), 1.5) * Math.sqrt(n) * (double)(n - 2));
    }
}

