/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.Gamma;
import com.opengamma.strata.math.impl.cern.MersenneTwister;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.Date;

public class GammaDistribution
implements ProbabilityDistribution<Double> {
    private final Gamma _gamma;
    private final double _k;
    private final double _theta;

    public GammaDistribution(double k, double theta) {
        this(k, theta, new MersenneTwister(new Date()));
    }

    public GammaDistribution(double k, double theta, RandomEngine engine) {
        ArgChecker.isTrue((k > 0.0 ? 1 : 0) != 0, (String)"k must be > 0");
        ArgChecker.isTrue((theta > 0.0 ? 1 : 0) != 0, (String)"theta must be > 0");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._gamma = new Gamma(k, 1.0 / theta, engine);
        this._k = k;
        this._theta = theta;
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._gamma.cdf(x);
    }

    @Override
    public double getInverseCDF(Double p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._gamma.pdf(x);
    }

    @Override
    public double nextRandom() {
        return this._gamma.nextDouble();
    }

    public double getK() {
        return this._k;
    }

    public double getTheta() {
        return this._theta;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._k);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._theta);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GammaDistribution other = (GammaDistribution)obj;
        if (Double.doubleToLongBits(this._k) != Double.doubleToLongBits(other._k)) {
            return false;
        }
        return Double.doubleToLongBits(this._theta) == Double.doubleToLongBits(other._theta);
    }
}

