/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.math.MathException;

final class INITDS {
    static int getInitds(double[] os, int nos, double eta) {
        if (os == null) {
            throw new MathException("INITDS: os is null");
        }
        if (nos != os.length) {
            throw new MathException("INITDS: nos and os.length are not equal, they should be!");
        }
        if (nos < 1) {
            throw new MathException("INITDS: Number of coeffs is less than 1");
        }
        double err = 0.0;
        int i = 0;
        boolean error = true;
        for (int ii = 0; ii < nos; ++ii) {
            i = nos - 1 - ii;
            if (!((err += Math.abs(os[i])) > eta)) continue;
            error = false;
            break;
        }
        if (error) {
            throw new MathException("INITDS: Chebyshev series too short for specified accuracy");
        }
        return i;
    }

    private INITDS() {
    }
}

