/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.leastsquare;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.Objects;

public class LeastSquareResults {
    private final double _chiSq;
    private final DoubleArray _parameters;
    private final DoubleMatrix _covariance;
    private final DoubleMatrix _inverseJacobian;

    public LeastSquareResults(LeastSquareResults from) {
        this(from._chiSq, from._parameters, from._covariance, from._inverseJacobian);
    }

    public LeastSquareResults(double chiSq, DoubleArray parameters, DoubleMatrix covariance) {
        this(chiSq, parameters, covariance, null);
    }

    public LeastSquareResults(double chiSq, DoubleArray parameters, DoubleMatrix covariance, DoubleMatrix inverseJacobian) {
        ArgChecker.isTrue((chiSq >= 0.0 ? 1 : 0) != 0, (String)"chi square < 0");
        ArgChecker.notNull((Object)parameters, (String)"parameters");
        ArgChecker.notNull((Object)covariance, (String)"covariance");
        int n = parameters.size();
        ArgChecker.isTrue((covariance.columnCount() == n ? 1 : 0) != 0, (String)"covariance matrix not square");
        ArgChecker.isTrue((covariance.rowCount() == n ? 1 : 0) != 0, (String)"covariance matrix wrong size");
        this._chiSq = chiSq;
        this._parameters = parameters;
        this._covariance = covariance;
        this._inverseJacobian = inverseJacobian;
    }

    public double getChiSq() {
        return this._chiSq;
    }

    public DoubleArray getFitParameters() {
        return this._parameters;
    }

    public DoubleMatrix getCovariance() {
        return this._covariance;
    }

    public DoubleMatrix getFittingParameterSensitivityToData() {
        if (this._inverseJacobian == null) {
            throw new UnsupportedOperationException("The inverse Jacobian was not set");
        }
        return this._inverseJacobian;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._chiSq);
        result = prime * result + (int)(temp ^ temp >>> 32);
        result = prime * result + this._covariance.hashCode();
        result = prime * result + this._parameters.hashCode();
        result = prime * result + (this._inverseJacobian == null ? 0 : this._inverseJacobian.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeastSquareResults other = (LeastSquareResults)obj;
        if (Double.doubleToLongBits(this._chiSq) != Double.doubleToLongBits(other._chiSq)) {
            return false;
        }
        if (!Objects.equals(this._covariance, other._covariance)) {
            return false;
        }
        if (!Objects.equals(this._inverseJacobian, other._inverseJacobian)) {
            return false;
        }
        return Objects.equals(this._parameters, other._parameters);
    }

    public String toString() {
        return "LeastSquareResults [chiSq=" + this._chiSq + ", fit parameters=" + this._parameters.toString() + ", covariance=" + this._covariance.toString() + "]";
    }
}

