/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.leastsquare;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import com.opengamma.strata.math.impl.minimization.NonLinearParameterTransforms;
import com.opengamma.strata.math.impl.statistics.leastsquare.LeastSquareResults;

public class LeastSquareResultsWithTransform
extends LeastSquareResults {
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();
    private final NonLinearParameterTransforms _transform;
    private final DoubleArray _modelParameters;
    private DoubleMatrix _inverseJacobianModelPararms;

    public LeastSquareResultsWithTransform(LeastSquareResults transformedFitResult) {
        super(transformedFitResult);
        this._transform = null;
        this._modelParameters = transformedFitResult.getFitParameters();
        this._inverseJacobianModelPararms = this.getFittingParameterSensitivityToData();
    }

    public LeastSquareResultsWithTransform(LeastSquareResults transformedFitResult, NonLinearParameterTransforms transform) {
        super(transformedFitResult);
        ArgChecker.notNull((Object)transform, (String)"null transform");
        this._transform = transform;
        this._modelParameters = transform.inverseTransform(this.getFitParameters());
    }

    public DoubleArray getModelParameters() {
        return this._modelParameters;
    }

    public DoubleMatrix getModelParameterSensitivityToData() {
        if (this._inverseJacobianModelPararms == null) {
            this.setModelParameterSensitivityToData();
        }
        return this._inverseJacobianModelPararms;
    }

    private void setModelParameterSensitivityToData() {
        DoubleMatrix invJac = this._transform.inverseJacobian(this.getFitParameters());
        this._inverseJacobianModelPararms = (DoubleMatrix)MA.multiply((Matrix)invJac, (Matrix)this.getFittingParameterSensitivityToData());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this._inverseJacobianModelPararms == null ? 0 : this._inverseJacobianModelPararms.hashCode());
        result = prime * result + (this._modelParameters == null ? 0 : this._modelParameters.hashCode());
        result = prime * result + (this._transform == null ? 0 : this._transform.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeastSquareResultsWithTransform other = (LeastSquareResultsWithTransform)obj;
        if (this._inverseJacobianModelPararms == null ? other._inverseJacobianModelPararms != null : !this._inverseJacobianModelPararms.equals((Object)other._inverseJacobianModelPararms)) {
            return false;
        }
        if (this._modelParameters == null ? other._modelParameters != null : !this._modelParameters.equals((Object)other._modelParameters)) {
            return false;
        }
        return !(this._transform == null ? other._transform != null : !this._transform.equals(other._transform));
    }

    @Override
    public String toString() {
        return "LeastSquareResults [chiSq=" + this.getChiSq() + ", fit parameters=" + this.getFitParameters().toString() + ", model parameters= " + this.getModelParameters().toString() + ", covariance=" + this.getCovariance().toString() + "]";
    }
}

