/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.util;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.function.Function;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public final class CommonsMathWrapper {
    private CommonsMathWrapper() {
    }

    public static UnivariateFunction wrapUnivariate(Function<Double, Double> f) {
        ArgChecker.notNull(f, (String)"f");
        return f::apply;
    }

    public static RealMatrix wrap(DoubleMatrix x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return new Array2DRowRealMatrix(x.toArrayUnsafe());
    }

    public static RealMatrix wrapAsMatrix(DoubleArray x) {
        ArgChecker.notNull((Object)x, (String)"x");
        int n = x.size();
        double[][] y = new double[n][1];
        for (int i = 0; i < n; ++i) {
            y[i][0] = x.get(i);
        }
        return new Array2DRowRealMatrix(x.toArrayUnsafe());
    }

    public static DoubleMatrix unwrap(RealMatrix x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return DoubleMatrix.ofUnsafe((double[][])x.getData());
    }

    public static RealVector wrap(DoubleArray x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return new ArrayRealVector(x.toArrayUnsafe());
    }

    public static DoubleArray unwrap(RealVector x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return DoubleArray.ofUnsafe((double[])x.toArray());
    }
}

