/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.util;

public final class Epsilon {
    private static final double[] COEFF1 = new double[]{0.041666666666666664, 0.16666666666666666, 0.5, 1.0};
    private static final double[] COEFF2 = new double[]{0.006944444444444444, 0.03333333333333333, 0.125, 0.3333333333333333, 0.5};
    private static final double[] COEFF3 = new double[]{0.005952380952380952, 0.027777777777777776, 0.1, 0.25, 0.3333333333333333};

    public static double epsilon(double x) {
        if (Math.abs(x) > 1.0E-10) {
            return Math.expm1(x) / x;
        }
        return Epsilon.taylor(x, COEFF1);
    }

    public static double epsilonP(double x) {
        if (Math.abs(x) > 1.0E-7) {
            return ((x - 1.0) * Math.expm1(x) + x) / x / x;
        }
        return Epsilon.taylor(x, COEFF2);
    }

    public static double epsilonPP(double x) {
        if (Math.abs(x) > 1.0E-5) {
            double x2 = x * x;
            double x3 = x * x2;
            return (Math.expm1(x) * (x2 - 2.0 * x + 2.0) + x2 - 2.0 * x) / x3;
        }
        return Epsilon.taylor(x, COEFF3);
    }

    private static double taylor(double x, double[] coeff) {
        double sum = coeff[0];
        int n = coeff.length;
        for (int i = 1; i < n; ++i) {
            sum = coeff[i] + x * sum;
        }
        return sum;
    }

    private Epsilon() {
    }
}

