/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.rootfind;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.SVDecompositionCommons;
import com.opengamma.strata.math.impl.rootfinding.newton.BroydenVectorRootFinder;
import com.opengamma.strata.math.linearalgebra.Decomposition;
import java.util.function.Function;

public interface NewtonVectorRootFinder {
    public static NewtonVectorRootFinder broyden() {
        return new BroydenVectorRootFinder(new SVDecompositionCommons());
    }

    public static NewtonVectorRootFinder broyden(double absoluteTol, double relativeTol, int maxSteps) {
        return new BroydenVectorRootFinder(absoluteTol, relativeTol, maxSteps, new SVDecompositionCommons());
    }

    public static NewtonVectorRootFinder broyden(double absoluteTol, double relativeTol, int maxSteps, Decomposition<?> decomposition) {
        return new BroydenVectorRootFinder(absoluteTol, relativeTol, maxSteps, decomposition);
    }

    public DoubleArray findRoot(Function<DoubleArray, DoubleArray> var1, DoubleArray var2);

    public DoubleArray findRoot(Function<DoubleArray, DoubleArray> var1, Function<DoubleArray, DoubleMatrix> var2, DoubleArray var3);
}

