/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.bond.BondFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.bond.BondFutureOptionMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.pricer.bond.BlackBondFutureOptionMarginedTradePricer;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.bond.ResolvedBondFutureOptionTrade;

public class BondFutureOptionTradeCalculations {
    public static final BondFutureOptionTradeCalculations DEFAULT = new BondFutureOptionTradeCalculations(BlackBondFutureOptionMarginedTradePricer.DEFAULT);
    private final BondFutureOptionMeasureCalculations calc;

    public BondFutureOptionTradeCalculations(BlackBondFutureOptionMarginedTradePricer tradePricer) {
        this.calc = new BondFutureOptionMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingMarketDataLookup legalEntityLookup, BondFutureOptionMarketDataLookup volsLookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, legalEntityLookup.marketDataView(marketData), volsLookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        return this.calc.presentValue(trade, discountingProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingMarketDataLookup legalEntityLookup, BondFutureOptionMarketDataLookup volsLookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, legalEntityLookup.marketDataView(marketData), volsLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        return this.calc.pv01CalibratedSum(trade, discountingProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingMarketDataLookup legalEntityLookup, BondFutureOptionMarketDataLookup volsLookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, legalEntityLookup.marketDataView(marketData), volsLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        return this.calc.pv01CalibratedBucketed(trade, discountingProvider, volatilities);
    }

    public DoubleScenarioArray unitPrice(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingMarketDataLookup legalEntityLookup, BondFutureOptionMarketDataLookup volsLookup, ScenarioMarketData marketData) {
        return this.calc.unitPrice(trade, legalEntityLookup.marketDataView(marketData), volsLookup.marketDataView(marketData));
    }

    public double unitPrice(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        return this.calc.unitPrice(trade, discountingProvider, volatilities);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingMarketDataLookup legalEntityLookup, BondFutureOptionMarketDataLookup volsLookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, legalEntityLookup.marketDataView(marketData), volsLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        return this.calc.currencyExposure(trade, discountingProvider, volatilities);
    }
}

