/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.bond.BondFutureMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.pricer.bond.DiscountingBondFutureTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.bond.ResolvedBondFutureTrade;

public class BondFutureTradeCalculations {
    public static final BondFutureTradeCalculations DEFAULT = new BondFutureTradeCalculations(DiscountingBondFutureTradePricer.DEFAULT);
    private final BondFutureMeasureCalculations calc;

    public BondFutureTradeCalculations(DiscountingBondFutureTradePricer tradePricer) {
        this.calc = new BondFutureMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.calc.presentValue(trade, discountingProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.calc.pv01CalibratedSum(trade, discountingProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.calc.pv01CalibratedBucketed(trade, discountingProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.calc.parSpread(trade, discountingProvider);
    }

    public DoubleScenarioArray unitPrice(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.unitPrice(trade, lookup.marketDataView(marketData));
    }

    public double unitPrice(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.calc.unitPrice(trade, discountingProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedBondFutureTrade trade, LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.calc.currencyExposure(trade, discountingProvider);
    }
}

