/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.bond.BondFutureOptionMarketData;
import com.opengamma.strata.measure.bond.BondFutureOptionMarketDataLookup;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.product.SecurityId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultBondFutureOptionMarketData
implements BondFutureOptionMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final BondFutureOptionMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private static final TypedMetaBean<DefaultBondFutureOptionMarketData> META_BEAN = LightMetaBean.of(DefaultBondFutureOptionMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultBondFutureOptionMarketData of(BondFutureOptionMarketDataLookup lookup, MarketData marketData) {
        return new DefaultBondFutureOptionMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultBondFutureOptionMarketData(BondFutureOptionMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (BondFutureOptionMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    @Override
    public BondFutureOptionMarketData withMarketData(MarketData marketData) {
        return DefaultBondFutureOptionMarketData.of(this.lookup, marketData);
    }

    @Override
    public BondFutureVolatilities volatilities(SecurityId securityId) {
        return this.lookup.volatilities(securityId, this.marketData);
    }

    public static TypedMetaBean<DefaultBondFutureOptionMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultBondFutureOptionMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public BondFutureOptionMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultBondFutureOptionMarketData other = (DefaultBondFutureOptionMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultBondFutureOptionMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

