/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.calc;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.Trade;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class TradeCounterpartyCalculationParameter
implements CalculationParameter,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Class<? extends CalculationParameter> queryType;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<StandardId, CalculationParameter> parameters;
    @PropertyDefinition(validate="notNull")
    private final CalculationParameter defaultParameter;
    private static final TypedMetaBean<TradeCounterpartyCalculationParameter> META_BEAN = LightMetaBean.of(TradeCounterpartyCalculationParameter.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"queryType", "parameters", "defaultParameter"}, (Object[])new Object[]{null, ImmutableMap.of(), null});
    private static final long serialVersionUID = 1L;

    public static TradeCounterpartyCalculationParameter of(Map<StandardId, CalculationParameter> parameters, CalculationParameter defaultParameter) {
        ArgChecker.notEmpty(parameters, (String)"values");
        ArgChecker.notNull((Object)defaultParameter, (String)"defaultParameter");
        Class queryType = defaultParameter.queryType();
        for (CalculationParameter value : parameters.values()) {
            if (value.queryType() == queryType) continue;
            throw new IllegalArgumentException(Messages.format((String)"Map contained a parameter '{}' that did not match the expected query type '{}'", (Object[])new Object[]{value, queryType.getClass().getSimpleName()}));
        }
        return new TradeCounterpartyCalculationParameter(queryType, (Map<StandardId, CalculationParameter>)ImmutableMap.copyOf(parameters), defaultParameter);
    }

    public Class<? extends CalculationParameter> queryType() {
        return this.queryType;
    }

    public Optional<CalculationParameter> filter(CalculationTarget target, Measure measure) {
        Trade trade;
        Optional idOpt;
        if (target instanceof Trade && (idOpt = (trade = (Trade)target).getInfo().getCounterparty()).isPresent()) {
            StandardId id = (StandardId)idOpt.get();
            CalculationParameter value = (CalculationParameter)this.parameters.getOrDefault((Object)id, (Object)this.defaultParameter);
            return value.filter(target, measure);
        }
        return this.defaultParameter.filter(target, measure);
    }

    public static TypedMetaBean<TradeCounterpartyCalculationParameter> meta() {
        return META_BEAN;
    }

    private TradeCounterpartyCalculationParameter(Class<? extends CalculationParameter> queryType, Map<StandardId, CalculationParameter> parameters, CalculationParameter defaultParameter) {
        JodaBeanUtils.notNull(queryType, (String)"queryType");
        JodaBeanUtils.notNull(parameters, (String)"parameters");
        JodaBeanUtils.notNull((Object)defaultParameter, (String)"defaultParameter");
        this.queryType = queryType;
        this.parameters = ImmutableMap.copyOf(parameters);
        this.defaultParameter = defaultParameter;
    }

    public TypedMetaBean<TradeCounterpartyCalculationParameter> metaBean() {
        return META_BEAN;
    }

    public Class<? extends CalculationParameter> getQueryType() {
        return this.queryType;
    }

    public ImmutableMap<StandardId, CalculationParameter> getParameters() {
        return this.parameters;
    }

    public CalculationParameter getDefaultParameter() {
        return this.defaultParameter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TradeCounterpartyCalculationParameter other = (TradeCounterpartyCalculationParameter)obj;
            return JodaBeanUtils.equal(this.queryType, other.queryType) && JodaBeanUtils.equal(this.parameters, other.parameters) && JodaBeanUtils.equal((Object)this.defaultParameter, (Object)other.defaultParameter);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.queryType);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.defaultParameter);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("TradeCounterpartyCalculationParameter{");
        buf.append("queryType").append('=').append(JodaBeanUtils.toString(this.queryType)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString(this.parameters)).append(',').append(' ');
        buf.append("defaultParameter").append('=').append(JodaBeanUtils.toString((Object)this.defaultParameter));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

