/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.capfloor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.measure.capfloor.IborCapFloorMarketDataLookup;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultIborCapFloorMarketDataLookup
implements IborCapFloorMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<IborIndex, IborCapletFloorletVolatilitiesId> volatilityIds;
    private static final TypedMetaBean<DefaultIborCapFloorMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultIborCapFloorMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"volatilityIds"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static DefaultIborCapFloorMarketDataLookup of(IborIndex index, IborCapletFloorletVolatilitiesId volatilityId) {
        return new DefaultIborCapFloorMarketDataLookup((Map<IborIndex, IborCapletFloorletVolatilitiesId>)ImmutableMap.of((Object)index, (Object)volatilityId));
    }

    public static DefaultIborCapFloorMarketDataLookup of(Map<IborIndex, IborCapletFloorletVolatilitiesId> volatilityIds) {
        return new DefaultIborCapFloorMarketDataLookup(volatilityIds);
    }

    @Override
    public ImmutableSet<IborIndex> getVolatilityIndices() {
        return this.volatilityIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getVolatilityIds(IborIndex index) {
        IborCapletFloorletVolatilitiesId id = (IborCapletFloorletVolatilitiesId)this.volatilityIds.get((Object)index);
        if (id == null) {
            throw new IllegalArgumentException(this.msgIndexNotFound((Index)index));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(Set<IborIndex> indices) {
        ImmutableSet.Builder requiredIndices = ImmutableSet.builder();
        for (IborIndex index : indices) {
            if (!this.volatilityIds.containsKey((Object)index)) {
                throw new IllegalArgumentException(this.msgIndexNotFound((Index)index));
            }
            requiredIndices.add(Objects.requireNonNull(this.volatilityIds.get((Object)index)));
        }
        return FunctionRequirements.builder().valueRequirements((Set)requiredIndices.build()).build();
    }

    @Override
    public IborCapletFloorletVolatilities volatilities(IborIndex index, MarketData marketData) {
        IborCapletFloorletVolatilitiesId volatilityId = (IborCapletFloorletVolatilitiesId)this.volatilityIds.get((Object)index);
        if (volatilityId == null) {
            throw new MarketDataNotFoundException(this.msgIndexNotFound((Index)index));
        }
        return (IborCapletFloorletVolatilities)marketData.getValue((MarketDataId)volatilityId);
    }

    private String msgIndexNotFound(Index index) {
        return Messages.format((String)"Ibor cap/floor lookup has no volatilities defined for index '{}'", (Object)index);
    }

    public static TypedMetaBean<DefaultIborCapFloorMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultIborCapFloorMarketDataLookup(Map<IborIndex, IborCapletFloorletVolatilitiesId> volatilityIds) {
        JodaBeanUtils.notNull(volatilityIds, (String)"volatilityIds");
        this.volatilityIds = ImmutableMap.copyOf(volatilityIds);
    }

    public TypedMetaBean<DefaultIborCapFloorMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<IborIndex, IborCapletFloorletVolatilitiesId> getVolatilityIds() {
        return this.volatilityIds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultIborCapFloorMarketDataLookup other = (DefaultIborCapFloorMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.volatilityIds, other.volatilityIds);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.volatilityIds);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultIborCapFloorMarketDataLookup{");
        buf.append("volatilityIds").append('=').append(JodaBeanUtils.toString(this.volatilityIds));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

