/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.capfloor;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.capfloor.IborCapFloorMarketDataLookup;
import com.opengamma.strata.measure.capfloor.IborCapFloorMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorTrade;

public class IborCapFloorTradeCalculations {
    public static final IborCapFloorTradeCalculations DEFAULT = new IborCapFloorTradeCalculations(VolatilityIborCapFloorTradePricer.DEFAULT);
    private final IborCapFloorMeasureCalculations calc;

    public IborCapFloorTradeCalculations(VolatilityIborCapFloorTradePricer tradePricer) {
        this.calc = new IborCapFloorMeasureCalculations(tradePricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount presentValue(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.presentValue(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.currencyExposure(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray currentCash(ResolvedIborCapFloorTrade trade, RatesMarketDataLookup ratesLookup, IborCapFloorMarketDataLookup capFloorLookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, ratesLookup.marketDataView(marketData), capFloorLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currentCash(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        return this.calc.currentCash(trade, ratesProvider, volatilities);
    }
}

