/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.cms;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.cms.CmsMeasureCalculations;
import com.opengamma.strata.measure.cms.CmsSabrExtrapolationParams;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.measure.swaption.SwaptionMarketDataLookup;
import com.opengamma.strata.measure.swaption.SwaptionScenarioMarketData;
import com.opengamma.strata.product.cms.Cms;
import com.opengamma.strata.product.cms.CmsTrade;
import com.opengamma.strata.product.cms.ResolvedCmsTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CmsTradeCalculationFunction
implements CalculationFunction<CmsTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, CmsMeasureCalculations::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, CmsMeasureCalculations::pv01RatesCalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, CmsMeasureCalculations::pv01RatesCalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, CmsMeasureCalculations::pv01RatesMarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, CmsMeasureCalculations::pv01RatesMarketQuoteBucketed).put((Object)Measures.CURRENCY_EXPOSURE, CmsMeasureCalculations::currencyExposure).put((Object)Measures.CURRENT_CASH, CmsMeasureCalculations::currentCash).put((Object)Measures.RESOLVED_TARGET, (c, rt, smd, m) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<CmsTrade> targetType() {
        return CmsTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(CmsTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(CmsTrade trade, ReferenceData refData) {
        return trade.getProduct().getCmsLeg().getCurrency();
    }

    public FunctionRequirements requirements(CmsTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        Cms product = trade.getProduct();
        ImmutableSet currencies = product.allPaymentCurrencies();
        RateIndex cmsIndex = trade.getProduct().getCmsLeg().getUnderlyingIndex();
        ImmutableSet payIndices = trade.getProduct().allRateIndices();
        ImmutableSet indices = ImmutableSet.builder().add((Object)cmsIndex).addAll((Iterable)payIndices).build();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements((Set<Currency>)currencies, (Set<? extends Index>)indices);
        SwaptionMarketDataLookup swaptionLookup = (SwaptionMarketDataLookup)parameters.getParameter(SwaptionMarketDataLookup.class);
        FunctionRequirements swaptionReqs = swaptionLookup.requirements(cmsIndex);
        return ratesReqs.combinedWith(swaptionReqs);
    }

    public Map<Measure, Result<?>> calculate(CmsTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedCmsTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        SwaptionMarketDataLookup swaptionLookup = (SwaptionMarketDataLookup)parameters.getParameter(SwaptionMarketDataLookup.class);
        SwaptionScenarioMarketData swaptionMarketData = swaptionLookup.marketDataView(scenarioMarketData);
        CmsSabrExtrapolationParams cmsParams = (CmsSabrExtrapolationParams)parameters.getParameter(CmsSabrExtrapolationParams.class);
        CmsMeasureCalculations calculations = new CmsMeasureCalculations(cmsParams);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, calculations, ratesMarketData, swaptionMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedCmsTrade trade, CmsMeasureCalculations calculations, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for SwaptionTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(calculations, trade, ratesMarketData, swaptionMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(CmsMeasureCalculations var1, ResolvedCmsTrade var2, RatesScenarioMarketData var3, SwaptionScenarioMarketData var4);
    }
}

