/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.cms;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.cms.CmsMeasureCalculations;
import com.opengamma.strata.measure.cms.CmsSabrExtrapolationParams;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.swaption.SwaptionMarketDataLookup;
import com.opengamma.strata.pricer.cms.SabrExtrapolationReplicationCmsTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.product.cms.ResolvedCmsTrade;

public class CmsTradeCalculations {
    private final CmsMeasureCalculations calc;

    public static CmsTradeCalculations of(CmsSabrExtrapolationParams cmsParams) {
        return new CmsTradeCalculations(cmsParams);
    }

    private CmsTradeCalculations(CmsSabrExtrapolationParams cmsParams) {
        this.calc = new CmsMeasureCalculations(cmsParams);
    }

    public CmsTradeCalculations(SabrExtrapolationReplicationCmsTradePricer tradePricer) {
        this.calc = new CmsMeasureCalculations(tradePricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount presentValue(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.presentValue(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.currencyExposure(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray currentCash(ResolvedCmsTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currentCash(ResolvedCmsTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.currentCash(trade, ratesProvider, volatilities);
    }
}

