/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.credit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.credit.CdsMeasureCalculations;
import com.opengamma.strata.measure.credit.CreditMeasures;
import com.opengamma.strata.measure.credit.CreditRatesMarketDataLookup;
import com.opengamma.strata.measure.credit.CreditRatesScenarioMarketData;
import com.opengamma.strata.product.credit.Cds;
import com.opengamma.strata.product.credit.CdsTrade;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CdsTradeCalculationFunction
implements CalculationFunction<CdsTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, CdsMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, CdsMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, CdsMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, CdsMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, CdsMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.UNIT_PRICE, CdsMeasureCalculations.DEFAULT::unitPrice).put((Object)CreditMeasures.PRINCIPAL, CdsMeasureCalculations.DEFAULT::principal).put((Object)CreditMeasures.IR01_CALIBRATED_PARALLEL, CdsMeasureCalculations.DEFAULT::ir01CalibratedParallel).put((Object)CreditMeasures.IR01_CALIBRATED_BUCKETED, CdsMeasureCalculations.DEFAULT::ir01CalibratedBucketed).put((Object)CreditMeasures.IR01_MARKET_QUOTE_PARALLEL, CdsMeasureCalculations.DEFAULT::ir01MarketQuoteParallel).put((Object)CreditMeasures.IR01_MARKET_QUOTE_BUCKETED, CdsMeasureCalculations.DEFAULT::ir01MarketQuoteBucketed).put((Object)CreditMeasures.CS01_PARALLEL, CdsMeasureCalculations.DEFAULT::cs01Parallel).put((Object)CreditMeasures.CS01_BUCKETED, CdsMeasureCalculations.DEFAULT::cs01Bucketed).put((Object)CreditMeasures.RECOVERY01, CdsMeasureCalculations.DEFAULT::recovery01).put((Object)CreditMeasures.JUMP_TO_DEFAULT, CdsMeasureCalculations.DEFAULT::jumpToDefault).put((Object)CreditMeasures.EXPECTED_LOSS, CdsMeasureCalculations.DEFAULT::expectedLoss).put((Object)Measures.RESOLVED_TARGET, (rt, smd, rd) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<CdsTrade> targetType() {
        return CdsTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(CdsTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(CdsTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrency();
    }

    public FunctionRequirements requirements(CdsTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        Cds product = trade.getProduct();
        StandardId legalEntityId = product.getLegalEntityId();
        Currency currency = product.getCurrency();
        CreditRatesMarketDataLookup lookup = (CreditRatesMarketDataLookup)parameters.getParameter(CreditRatesMarketDataLookup.class);
        return lookup.requirements(legalEntityId, currency);
    }

    public Map<Measure, Result<?>> calculate(CdsTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedCdsTrade resolved = trade.resolve(refData);
        CreditRatesMarketDataLookup ledLookup = (CreditRatesMarketDataLookup)parameters.getParameter(CreditRatesMarketDataLookup.class);
        CreditRatesScenarioMarketData marketData = ledLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData, refData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedCdsTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for CdsTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, marketData, refData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedCdsTrade var1, CreditRatesScenarioMarketData var2, ReferenceData var3);
    }
}

