/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.deposit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.deposit.TermDepositMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;
import com.opengamma.strata.product.deposit.TermDeposit;
import com.opengamma.strata.product.deposit.TermDepositTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TermDepositTradeCalculationFunction
implements CalculationFunction<TermDepositTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, TermDepositMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, TermDepositMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, TermDepositMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, TermDepositMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, TermDepositMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.PAR_RATE, TermDepositMeasureCalculations.DEFAULT::parRate).put((Object)Measures.PAR_SPREAD, TermDepositMeasureCalculations.DEFAULT::parSpread).put((Object)Measures.CURRENCY_EXPOSURE, TermDepositMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, TermDepositMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<TermDepositTrade> targetType() {
        return TermDepositTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(TermDepositTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(TermDepositTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrency();
    }

    public FunctionRequirements requirements(TermDepositTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        TermDeposit product = trade.getProduct();
        Currency currency = product.getCurrency();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        return ratesLookup.requirements(currency, new Index[0]);
    }

    public Map<Measure, Result<?>> calculate(TermDepositTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedTermDepositTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData marketData = ratesLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedTermDepositTrade trade, RatesScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for TermDepositTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedTermDepositTrade var1, RatesScenarioMarketData var2);
    }
}

