/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.fx.DiscountingFxSwapTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.fx.ResolvedFxSwapTrade;

final class FxSwapMeasureCalculations {
    public static final FxSwapMeasureCalculations DEFAULT = new FxSwapMeasureCalculations(DiscountingFxSwapTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingFxSwapTradePricer tradePricer;

    FxSwapMeasureCalculations(DiscountingFxSwapTradePricer tradePricer) {
        this.tradePricer = (DiscountingFxSwapTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount presentValue(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.presentValue(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    DoubleScenarioArray parSpread(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parSpread(trade, marketData.scenario(i).ratesProvider()));
    }

    double parSpread(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.parSpread(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currencyExposure(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray currentCash(ResolvedFxSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currentCash(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currentCash(trade, ratesProvider);
    }
}

