/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.fx.FxSwapMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.fx.DiscountingFxSwapTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSwapTrade;

public class FxSwapTradeCalculations {
    public static final FxSwapTradeCalculations DEFAULT = new FxSwapTradeCalculations(DiscountingFxSwapTradePricer.DEFAULT);
    private final FxSwapMeasureCalculations calc;

    public FxSwapTradeCalculations(DiscountingFxSwapTradePricer tradePricer) {
        this.calc = new FxSwapMeasureCalculations(tradePricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.parSpread(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currentCash(ResolvedFxSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currentCash(ResolvedFxSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }
}

