/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.fxopt.FxOptionMarketData;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultFxOptionMarketData
implements FxOptionMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxOptionMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private static final TypedMetaBean<DefaultFxOptionMarketData> META_BEAN = LightMetaBean.of(DefaultFxOptionMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultFxOptionMarketData of(FxOptionMarketDataLookup lookup, MarketData marketData) {
        return new DefaultFxOptionMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultFxOptionMarketData(FxOptionMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (FxOptionMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    @Override
    public FxOptionMarketData withMarketData(MarketData marketData) {
        return DefaultFxOptionMarketData.of(this.lookup, marketData);
    }

    @Override
    public FxOptionVolatilities volatilities(CurrencyPair currencyPair) {
        return this.lookup.volatilities(currencyPair, this.marketData);
    }

    public static TypedMetaBean<DefaultFxOptionMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultFxOptionMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public FxOptionMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultFxOptionMarketData other = (DefaultFxOptionMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultFxOptionMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

