/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.fxopt.DefaultFxOptionMarketData;
import com.opengamma.strata.measure.fxopt.DefaultFxOptionMarketDataLookup;
import com.opengamma.strata.measure.fxopt.DefaultFxOptionScenarioMarketData;
import com.opengamma.strata.measure.fxopt.FxOptionMarketData;
import com.opengamma.strata.measure.fxopt.FxOptionScenarioMarketData;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesId;
import java.util.Map;
import java.util.Set;

public interface FxOptionMarketDataLookup
extends CalculationParameter {
    public static FxOptionMarketDataLookup of(CurrencyPair currencyPair, FxOptionVolatilitiesId volatilityId) {
        return DefaultFxOptionMarketDataLookup.of((Map<CurrencyPair, FxOptionVolatilitiesId>)ImmutableMap.of((Object)currencyPair, (Object)volatilityId));
    }

    public static FxOptionMarketDataLookup of(Map<CurrencyPair, FxOptionVolatilitiesId> volatilityIds) {
        return DefaultFxOptionMarketDataLookup.of(volatilityIds);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return FxOptionMarketDataLookup.class;
    }

    public ImmutableSet<CurrencyPair> getVolatilityCurrencyPairs();

    public ImmutableSet<MarketDataId<?>> getVolatilityIds(CurrencyPair var1);

    default public FunctionRequirements requirements(CurrencyPair ... currencyPairs) {
        return this.requirements((Set<CurrencyPair>)ImmutableSet.copyOf((Object[])currencyPairs));
    }

    public FunctionRequirements requirements(Set<CurrencyPair> var1);

    default public FxOptionScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultFxOptionScenarioMarketData.of(this, marketData);
    }

    default public FxOptionMarketData marketDataView(MarketData marketData) {
        return DefaultFxOptionMarketData.of(this, marketData);
    }

    public FxOptionVolatilities volatilities(CurrencyPair var1, MarketData var2);
}

