/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesSpecification;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxOptionVolatilitiesDefinition
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxOptionVolatilitiesSpecification specification;
    private static final long serialVersionUID = 1L;

    public static FxOptionVolatilitiesDefinition of(FxOptionVolatilitiesSpecification specification) {
        return new FxOptionVolatilitiesDefinition(specification);
    }

    public FxOptionVolatilities volatilities(ZonedDateTime valuationDateTime, DoubleArray parameters, ReferenceData refData) {
        return this.specification.volatilities(valuationDateTime, parameters, refData);
    }

    public ImmutableList<QuoteId> volatilitiesInputs() {
        return this.specification.volatilitiesInputs();
    }

    public int getParameterCount() {
        return this.specification.getParameterCount();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxOptionVolatilitiesDefinition(FxOptionVolatilitiesSpecification specification) {
        JodaBeanUtils.notNull((Object)specification, (String)"specification");
        this.specification = specification;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxOptionVolatilitiesSpecification getSpecification() {
        return this.specification;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxOptionVolatilitiesDefinition other = (FxOptionVolatilitiesDefinition)obj;
            return JodaBeanUtils.equal((Object)this.specification, (Object)other.specification);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.specification);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("FxOptionVolatilitiesDefinition{");
        buf.append("specification").append('=').append(JodaBeanUtils.toString((Object)this.specification));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxOptionVolatilitiesDefinition> {
        private FxOptionVolatilitiesSpecification specification;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1307197699: {
                    return this.specification;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1307197699: {
                    this.specification = (FxOptionVolatilitiesSpecification)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxOptionVolatilitiesDefinition build() {
            return new FxOptionVolatilitiesDefinition(this.specification);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("FxOptionVolatilitiesDefinition.Builder{");
            buf.append("specification").append('=').append(JodaBeanUtils.toString((Object)this.specification));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxOptionVolatilitiesSpecification> specification = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"specification", FxOptionVolatilitiesDefinition.class, FxOptionVolatilitiesSpecification.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"specification"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1307197699: {
                    return this.specification;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxOptionVolatilitiesDefinition> builder() {
            return new Builder();
        }

        public Class<? extends FxOptionVolatilitiesDefinition> beanType() {
            return FxOptionVolatilitiesDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxOptionVolatilitiesSpecification> specification() {
            return this.specification;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1307197699: {
                    return ((FxOptionVolatilitiesDefinition)bean).getSpecification();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

