/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.measure.fxopt.FxSingleBarrierOptionMeasureCalculations;
import com.opengamma.strata.measure.fxopt.FxSingleBarrierOptionMethod;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.fxopt.BlackFxSingleBarrierOptionTradePricer;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOptionTrade;

public class FxSingleBarrierOptionTradeCalculations {
    public static final FxSingleBarrierOptionTradeCalculations DEFAULT = new FxSingleBarrierOptionTradeCalculations(BlackFxSingleBarrierOptionTradePricer.DEFAULT, ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer.DEFAULT);
    private final FxSingleBarrierOptionMeasureCalculations calc;

    public FxSingleBarrierOptionTradeCalculations(BlackFxSingleBarrierOptionTradePricer blackPricer, ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer trinomialTreePricer) {
        this.calc = new FxSingleBarrierOptionMeasureCalculations(blackPricer, trinomialTreePricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.presentValue(trade, ratesProvider, volatilities, method);
    }

    public MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesProvider, volatilities, method);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesProvider, volatilities, method);
    }

    public MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesProvider, volatilities, method);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesProvider, volatilities, method);
    }

    public ScenarioArray<CurrencyParameterSensitivities> vegaMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.vegaMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyParameterSensitivities vegaMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.vegaMarketQuoteBucketed(trade, ratesProvider, volatilities, method);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.currencyExposure(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.currencyExposure(trade, ratesProvider, volatilities, method);
    }

    public CurrencyScenarioArray currentCash(ResolvedFxSingleBarrierOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxSingleBarrierOptionMethod method) {
        return this.calc.currentCash(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyAmount currentCash(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        return this.calc.currentCash(trade, ratesProvider.getValuationDate(), method);
    }
}

