/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.fxopt.FxCalculationUtils;
import com.opengamma.strata.measure.fxopt.FxOptionScenarioMarketData;
import com.opengamma.strata.measure.fxopt.FxVanillaOptionMethod;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionSmileVolatilities;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.BlackFxVanillaOptionTradePricer;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.VannaVolgaFxVanillaOptionTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOptionTrade;
import java.time.LocalDate;

final class FxVanillaOptionMeasureCalculations {
    public static final FxVanillaOptionMeasureCalculations DEFAULT = new FxVanillaOptionMeasureCalculations(BlackFxVanillaOptionTradePricer.DEFAULT, VannaVolgaFxVanillaOptionTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final BlackFxVanillaOptionTradePricer blackPricer;
    private final VannaVolgaFxVanillaOptionTradePricer vannaVolgaPricer;

    FxVanillaOptionMeasureCalculations(BlackFxVanillaOptionTradePricer blackPricer, VannaVolgaFxVanillaOptionTradePricer vannaVolgaPricer) {
        this.blackPricer = (BlackFxVanillaOptionTradePricer)ArgChecker.notNull((Object)blackPricer, (String)"blackPricer");
        this.vannaVolgaPricer = (VannaVolgaFxVanillaOptionTradePricer)ArgChecker.notNull((Object)vannaVolgaPricer, (String)"vannaVolgaPricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount presentValue(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        if (method == FxVanillaOptionMethod.VANNA_VOLGA) {
            return this.vannaVolgaPricer.presentValue(trade, ratesProvider, FxCalculationUtils.checkVannaVolgaVolatilities(volatilities));
        }
        return this.blackPricer.presentValue(trade, ratesProvider, FxCalculationUtils.checkBlackVolatilities(volatilities));
    }

    MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.pointSensitivity(trade, ratesProvider, volatilities, method);
        return paramSens.total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.pointSensitivity(trade, ratesProvider, volatilities, method);
        return paramSens.multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteSum(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.pointSensitivity(trade, ratesProvider, volatilities, method);
        return MARKET_QUOTE_SENS.sensitivity(paramSens, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.pointSensitivity(trade, ratesProvider, volatilities, method);
        return MARKET_QUOTE_SENS.sensitivity(paramSens, ratesProvider).multipliedBy(1.0E-4);
    }

    private CurrencyParameterSensitivities pointSensitivity(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        PointSensitivities pointSens = method == FxVanillaOptionMethod.VANNA_VOLGA ? this.vannaVolgaPricer.presentValueSensitivityRatesStickyStrike(trade, ratesProvider, FxCalculationUtils.checkVannaVolgaVolatilities(volatilities)) : this.blackPricer.presentValueSensitivityRatesStickyStrike(trade, ratesProvider, FxCalculationUtils.checkBlackVolatilities(volatilities));
        return ratesProvider.parameterSensitivity(pointSens);
    }

    ScenarioArray<CurrencyParameterSensitivities> vegaMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.vegaMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    CurrencyParameterSensitivities vegaMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        if (method == FxVanillaOptionMethod.VANNA_VOLGA) {
            BlackFxOptionSmileVolatilities blackSmileVols = FxCalculationUtils.checkVannaVolgaVolatilities(volatilities);
            PointSensitivities pointSens = this.vannaVolgaPricer.presentValueSensitivityModelParamsVolatility(trade, ratesProvider, blackSmileVols);
            return blackSmileVols.parameterSensitivity(pointSens);
        }
        BlackFxOptionVolatilities blackVols = FxCalculationUtils.checkBlackVolatilities(volatilities);
        PointSensitivities pointSens = this.blackPricer.presentValueSensitivityModelParamsVolatility(trade, ratesProvider, blackVols);
        return blackVols.parameterSensitivity(pointSens);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currencyExposure(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount currencyExposure(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        if (method == FxVanillaOptionMethod.VANNA_VOLGA) {
            return this.vannaVolgaPricer.currencyExposure(trade, ratesProvider, FxCalculationUtils.checkVannaVolgaVolatilities(volatilities));
        }
        return this.blackPricer.currencyExposure(trade, ratesProvider, FxCalculationUtils.checkBlackVolatilities(volatilities));
    }

    CurrencyScenarioArray currentCash(ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        return CurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currentCash(trade, ratesMarketData.scenario(i).getValuationDate(), method));
    }

    CurrencyAmount currentCash(ResolvedFxVanillaOptionTrade trade, LocalDate valuationDate, FxVanillaOptionMethod method) {
        if (method == FxVanillaOptionMethod.VANNA_VOLGA) {
            return this.vannaVolgaPricer.currentCash(trade, valuationDate);
        }
        return this.blackPricer.currentCash(trade, valuationDate);
    }
}

