/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.index.IborFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.index.IborFutureOptionMeasureCalculations;
import com.opengamma.strata.measure.index.IborFutureOptionScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.SecuritizedProductPortfolioItem;
import com.opengamma.strata.product.index.IborFutureOption;
import com.opengamma.strata.product.index.IborFutureOptionPosition;
import com.opengamma.strata.product.index.IborFutureOptionTrade;
import com.opengamma.strata.product.index.ResolvedIborFutureOptionTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IborFutureOptionTradeCalculationFunction<T extends SecuritizedProductPortfolioItem<IborFutureOption> & Resolvable<ResolvedIborFutureOptionTrade>>
implements CalculationFunction<T> {
    public static final IborFutureOptionTradeCalculationFunction<IborFutureOptionTrade> TRADE = new IborFutureOptionTradeCalculationFunction<IborFutureOptionTrade>(IborFutureOptionTrade.class);
    public static final IborFutureOptionTradeCalculationFunction<IborFutureOptionPosition> POSITION = new IborFutureOptionTradeCalculationFunction<IborFutureOptionPosition>(IborFutureOptionPosition.class);
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, IborFutureOptionMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, IborFutureOptionMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, IborFutureOptionMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, IborFutureOptionMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, IborFutureOptionMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.UNIT_PRICE, IborFutureOptionMeasureCalculations.DEFAULT::unitPrice).put((Object)Measures.RESOLVED_TARGET, (rt, smd, m) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();
    private final Class<T> targetType;

    private IborFutureOptionTradeCalculationFunction(Class<T> targetType) {
        this.targetType = (Class)ArgChecker.notNull(targetType, (String)"targetType");
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(T target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(T target, ReferenceData refData) {
        return target.getCurrency();
    }

    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        IborFutureOption option = (IborFutureOption)target.getProduct();
        QuoteId optionQuoteId = QuoteId.of((StandardId)option.getSecurityId().getStandardId(), (FieldName)FieldName.SETTLEMENT_PRICE);
        Currency currency = option.getCurrency();
        IborIndex index = option.getIndex();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements(currency, new Index[]{index});
        IborFutureOptionMarketDataLookup optionLookup = (IborFutureOptionMarketDataLookup)parameters.getParameter(IborFutureOptionMarketDataLookup.class);
        FunctionRequirements optionReqs = optionLookup.requirements(index);
        ImmutableSet valueReqs = ImmutableSet.builder().add((Object)optionQuoteId).addAll((Iterable)ratesReqs.getValueRequirements()).addAll((Iterable)optionReqs.getValueRequirements()).build();
        return ratesReqs.toBuilder().valueRequirements((Set)valueReqs).build();
    }

    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedIborFutureOptionTrade resolved = (ResolvedIborFutureOptionTrade)((Resolvable)target).resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        IborFutureOptionMarketDataLookup optionLookup = (IborFutureOptionMarketDataLookup)parameters.getParameter(IborFutureOptionMarketDataLookup.class);
        IborFutureOptionScenarioMarketData optionMarketData = optionLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ratesMarketData, optionMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedIborFutureOptionTrade resolved, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for IborFutureOption: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(resolved, ratesMarketData, optionMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedIborFutureOptionTrade var1, RatesScenarioMarketData var2, IborFutureOptionScenarioMarketData var3);
    }
}

