/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.payment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.AdvancedMeasures;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.payment.BulletPaymentMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.payment.BulletPayment;
import com.opengamma.strata.product.payment.BulletPaymentTrade;
import com.opengamma.strata.product.payment.ResolvedBulletPaymentTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BulletPaymentTradeCalculationFunction
implements CalculationFunction<BulletPaymentTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, BulletPaymentMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.EXPLAIN_PRESENT_VALUE, BulletPaymentMeasureCalculations.DEFAULT::explainPresentValue).put((Object)Measures.PV01_CALIBRATED_SUM, BulletPaymentMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, BulletPaymentMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, BulletPaymentMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, BulletPaymentMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.CASH_FLOWS, BulletPaymentMeasureCalculations.DEFAULT::cashFlows).put((Object)Measures.CURRENCY_EXPOSURE, BulletPaymentMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, BulletPaymentMeasureCalculations.DEFAULT::currentCash).put((Object)AdvancedMeasures.PV01_SINGLE_NODE_GAMMA_BUCKETED, BulletPaymentMeasureCalculations.DEFAULT::pv01SingleNodeGammaBucketed).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<BulletPaymentTrade> targetType() {
        return BulletPaymentTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(BulletPaymentTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(BulletPaymentTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrency();
    }

    public FunctionRequirements requirements(BulletPaymentTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        BulletPayment product = trade.getProduct();
        Currency currency = product.getCurrency();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        return ratesLookup.requirements(currency, new Index[0]);
    }

    public Map<Measure, Result<?>> calculate(BulletPaymentTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedBulletPaymentTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData marketData = ratesLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for BulletPaymentTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedBulletPaymentTrade var1, RatesScenarioMarketData var2);
    }
}

