/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.rate.RatesMarketData;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultRatesMarketData
implements RatesMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final RatesMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private final transient RatesProvider ratesProvider;
    private static final TypedMetaBean<DefaultRatesMarketData> META_BEAN = LightMetaBean.of(DefaultRatesMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultRatesMarketData of(RatesMarketDataLookup lookup, MarketData marketData) {
        return new DefaultRatesMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultRatesMarketData(RatesMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (RatesMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.ratesProvider = lookup.ratesProvider(marketData);
    }

    private Object readResolve() {
        return new DefaultRatesMarketData(this.lookup, this.marketData);
    }

    @Override
    public RatesMarketData withMarketData(MarketData marketData) {
        return DefaultRatesMarketData.of(this.lookup, marketData);
    }

    @Override
    public RatesProvider ratesProvider() {
        return this.ratesProvider;
    }

    public static TypedMetaBean<DefaultRatesMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultRatesMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public RatesMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultRatesMarketData other = (DefaultRatesMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultRatesMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

