/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.FloatingRateIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.calc.runner.FxRateLookup;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.observable.IndexQuoteId;
import com.opengamma.strata.measure.rate.DefaultLookupRatesProvider;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultRatesMarketDataLookup
implements RatesMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Currency, CurveId> discountCurves;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends Index, CurveId>")
    private final ImmutableMap<Index, CurveId> forwardCurves;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ObservableSource observableSource;
    @PropertyDefinition(validate="notNull", alias="fxLookup", overrideGet=true)
    private final FxRateLookup fxRateLookup;
    private static final TypedMetaBean<DefaultRatesMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultRatesMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"discountCurves", "forwardCurves", "observableSource", "fxRateLookup"}, (Object[])new Object[]{ImmutableMap.of(), ImmutableMap.of(), null, null}).withAlias("fxLookup", "fxRateLookup");
    private static final long serialVersionUID = 1L;

    public static DefaultRatesMarketDataLookup of(Map<Currency, CurveId> discountCurveIds, Map<? extends Index, CurveId> forwardCurveIds, ObservableSource obsSource, FxRateLookup fxLookup) {
        return new DefaultRatesMarketDataLookup(discountCurveIds, forwardCurveIds, obsSource, fxLookup);
    }

    @Override
    public ImmutableSet<Currency> getDiscountCurrencies() {
        return this.discountCurves.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getDiscountMarketDataIds(Currency currency) {
        CurveId id = (CurveId)this.discountCurves.get((Object)currency);
        if (id == null) {
            throw new IllegalArgumentException(this.msgCurrencyNotFound(currency));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public ImmutableSet<Index> getForwardIndices() {
        return this.forwardCurves.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getForwardMarketDataIds(Index index) {
        CurveId id = (CurveId)this.forwardCurves.get((Object)index);
        if (id == null) {
            throw new IllegalArgumentException(this.msgIndexNotFound(index));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(Set<Currency> currencies, Set<? extends Index> indices) {
        for (Currency currency : currencies) {
            if (this.discountCurves.keySet().contains((Object)currency)) continue;
            throw new IllegalArgumentException(this.msgCurrencyNotFound(currency));
        }
        for (Index index : indices) {
            if (this.forwardCurves.keySet().contains((Object)index) || this.isHistoric(index)) continue;
            throw new IllegalArgumentException(this.msgIndexNotFound(index));
        }
        Set indexQuoteIds = (Set)indices.stream().map(IndexQuoteId::of).collect(Guavate.toImmutableSet());
        Set set = (Set)indices.stream().filter(Guavate.not(this::isHistoric)).map(idx -> (CurveId)this.forwardCurves.get(idx)).collect(Guavate.toImmutableSet());
        Set discountFactorsIds = (Set)currencies.stream().map(ccy -> (CurveId)this.discountCurves.get(ccy)).collect(Guavate.toImmutableSet());
        return FunctionRequirements.builder().valueRequirements((Set)Sets.union((Set)set, (Set)discountFactorsIds)).timeSeriesRequirements(indexQuoteIds).outputCurrencies(currencies).observableSource(this.observableSource).build();
    }

    private boolean isHistoric(Index index) {
        if (index instanceof FloatingRateIndex) {
            FloatingRateIndex fri = (FloatingRateIndex)index;
            return !fri.isActive();
        }
        return false;
    }

    @Override
    public RatesProvider ratesProvider(MarketData marketData) {
        return DefaultLookupRatesProvider.of(this, marketData);
    }

    @Override
    public FxRateProvider fxRateProvider(MarketData marketData) {
        return this.fxRateLookup.fxRateProvider(marketData);
    }

    String msgCurrencyNotFound(Currency currency) {
        return Messages.format((String)"Rates lookup has no discount curve defined for currency '{}'", (Object)currency);
    }

    String msgIndexNotFound(Index index) {
        return Messages.format((String)"Rates lookup has no forward curve defined for index '{}'", (Object)index);
    }

    @ImmutableValidator
    private void validate() {
        this.validateObservableSource((Collection<CurveId>)this.forwardCurves.values());
        this.validateObservableSource((Collection<CurveId>)this.discountCurves.values());
    }

    private void validateObservableSource(Collection<CurveId> curveIds) {
        for (CurveId curveId : curveIds) {
            if (curveId.getObservableSource().equals((Object)this.observableSource)) continue;
            throw new IllegalArgumentException(Messages.format((String)"The observable source '{}' must match the observable source in all curve IDs but found {}", (Object[])new Object[]{this.observableSource, curveId}));
        }
    }

    public static TypedMetaBean<DefaultRatesMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultRatesMarketDataLookup(Map<Currency, CurveId> discountCurves, Map<? extends Index, CurveId> forwardCurves, ObservableSource observableSource, FxRateLookup fxRateLookup) {
        JodaBeanUtils.notNull(discountCurves, (String)"discountCurves");
        JodaBeanUtils.notNull(forwardCurves, (String)"forwardCurves");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        JodaBeanUtils.notNull((Object)fxRateLookup, (String)"fxRateLookup");
        this.discountCurves = ImmutableMap.copyOf(discountCurves);
        this.forwardCurves = ImmutableMap.copyOf(forwardCurves);
        this.observableSource = observableSource;
        this.fxRateLookup = fxRateLookup;
        this.validate();
    }

    public TypedMetaBean<DefaultRatesMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<Currency, CurveId> getDiscountCurves() {
        return this.discountCurves;
    }

    public ImmutableMap<Index, CurveId> getForwardCurves() {
        return this.forwardCurves;
    }

    @Override
    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    @Override
    public FxRateLookup getFxRateLookup() {
        return this.fxRateLookup;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultRatesMarketDataLookup other = (DefaultRatesMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.discountCurves, other.discountCurves) && JodaBeanUtils.equal(this.forwardCurves, other.forwardCurves) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource) && JodaBeanUtils.equal((Object)this.fxRateLookup, (Object)other.fxRateLookup);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.discountCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.forwardCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxRateLookup);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("DefaultRatesMarketDataLookup{");
        buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
        buf.append("forwardCurves").append('=').append(JodaBeanUtils.toString(this.forwardCurves)).append(',').append(' ');
        buf.append("observableSource").append('=').append(JodaBeanUtils.toString((Object)this.observableSource)).append(',').append(' ');
        buf.append("fxRateLookup").append('=').append(JodaBeanUtils.toString((Object)this.fxRateLookup));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

