/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.ImmutableMarketData;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.RatesCurveGroup;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupId;
import com.opengamma.strata.market.curve.RatesCurveInputs;
import com.opengamma.strata.market.curve.RatesCurveInputsId;
import com.opengamma.strata.market.observable.IndexQuoteId;
import com.opengamma.strata.measure.curve.RootFinderConfig;
import com.opengamma.strata.pricer.curve.CalibrationMeasures;
import com.opengamma.strata.pricer.curve.RatesCurveCalibrator;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RatesCurveGroupMarketDataFunction
implements MarketDataFunction<RatesCurveGroup, RatesCurveGroupId> {
    private final CalibrationMeasures calibrationMeasures;

    public RatesCurveGroupMarketDataFunction() {
        this(CalibrationMeasures.PAR_SPREAD);
    }

    public RatesCurveGroupMarketDataFunction(CalibrationMeasures calibrationMeasures) {
        this.calibrationMeasures = (CalibrationMeasures)ArgChecker.notNull((Object)calibrationMeasures, (String)"calibrationMeasures");
    }

    public MarketDataRequirements requirements(RatesCurveGroupId id, MarketDataConfig marketDataConfig) {
        RatesCurveGroupDefinition groupDefn = (RatesCurveGroupDefinition)marketDataConfig.get(RatesCurveGroupDefinition.class, (TypedString)id.getCurveGroupName());
        List curveInputsIds = (List)groupDefn.getCurveDefinitions().stream().filter(defn -> this.requiresMarketData((CurveDefinition)defn)).map(defn -> defn.getName()).map(curveName -> RatesCurveInputsId.of((CurveGroupName)groupDefn.getName(), (CurveName)curveName, (ObservableSource)id.getObservableSource())).collect(Guavate.toImmutableList());
        List timeSeriesIds = (List)groupDefn.getEntries().stream().flatMap(entry -> entry.getIndices().stream()).distinct().map(index -> IndexQuoteId.of((Index)index)).collect(Guavate.toImmutableList());
        return MarketDataRequirements.builder().addValues((Collection)curveInputsIds).addTimeSeries((Collection)timeSeriesIds).build();
    }

    public MarketDataBox<RatesCurveGroup> build(RatesCurveGroupId id, MarketDataConfig marketDataConfig, ScenarioMarketData marketData, ReferenceData refData) {
        RootFinderConfig rfc = marketDataConfig.find(RootFinderConfig.class).orElse(RootFinderConfig.standard());
        RatesCurveCalibrator calibrator = RatesCurveCalibrator.of((double)rfc.getAbsoluteTolerance(), (double)rfc.getRelativeTolerance(), (int)rfc.getMaximumSteps(), (CalibrationMeasures)this.calibrationMeasures);
        CurveGroupName groupName = id.getCurveGroupName();
        RatesCurveGroupDefinition configuredDefn = (RatesCurveGroupDefinition)marketDataConfig.get(RatesCurveGroupDefinition.class, (TypedString)groupName);
        return this.buildCurveGroup(configuredDefn, calibrator, marketData, refData, id.getObservableSource());
    }

    public Class<RatesCurveGroupId> getMarketDataIdType() {
        return RatesCurveGroupId.class;
    }

    MarketDataBox<RatesCurveGroup> buildCurveGroup(RatesCurveGroupDefinition configuredGroup, RatesCurveCalibrator calibrator, ScenarioMarketData marketData, ReferenceData refData, ObservableSource obsSource) {
        CurveGroupName groupName = configuredGroup.getName();
        List inputBoxes = (List)configuredGroup.getCurveDefinitions().stream().map(curveDefn -> this.curveInputs((CurveDefinition)curveDefn, marketData, groupName, obsSource)).collect(Guavate.toImmutableList());
        MarketDataBox valuationDates = marketData.getValuationDate();
        boolean multipleValuationDates = valuationDates.isScenarioValue();
        boolean multipleValues = inputBoxes.stream().anyMatch(MarketDataBox::isScenarioValue);
        Map<ObservableId, LocalDateDoubleTimeSeries> fixings = this.extractFixings(marketData);
        return multipleValues || multipleValuationDates ? this.buildMultipleCurveGroups(configuredGroup, calibrator, (MarketDataBox<LocalDate>)valuationDates, inputBoxes, fixings, refData) : this.buildSingleCurveGroup(configuredGroup, calibrator, (LocalDate)valuationDates.getSingleValue(), inputBoxes, fixings, refData);
    }

    private Map<ObservableId, LocalDateDoubleTimeSeries> extractFixings(ScenarioMarketData marketData) {
        HashMap<ObservableId, LocalDateDoubleTimeSeries> fixings = new HashMap<ObservableId, LocalDateDoubleTimeSeries>();
        for (ObservableId id : marketData.getTimeSeriesIds()) {
            fixings.put(id, marketData.getTimeSeries(id));
        }
        return fixings;
    }

    private MarketDataBox<RatesCurveGroup> buildMultipleCurveGroups(RatesCurveGroupDefinition configuredGroup, RatesCurveCalibrator calibrator, MarketDataBox<LocalDate> valuationDateBox, List<MarketDataBox<RatesCurveInputs>> inputBoxes, Map<ObservableId, LocalDateDoubleTimeSeries> fixings, ReferenceData refData) {
        int scenarioCount = RatesCurveGroupMarketDataFunction.scenarioCount(valuationDateBox, inputBoxes);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < scenarioCount; ++i) {
            LocalDate valuationDate = (LocalDate)valuationDateBox.getValue(i);
            RatesCurveGroupDefinition filteredGroup = configuredGroup.filtered(valuationDate, refData);
            List<RatesCurveInputs> curveInputsList = RatesCurveGroupMarketDataFunction.inputsForScenario(inputBoxes, i);
            MarketData inputs = RatesCurveGroupMarketDataFunction.inputsByKey(valuationDate, curveInputsList, fixings);
            builder.add((Object)this.buildGroup(filteredGroup, calibrator, inputs, refData));
        }
        ImmutableList curveGroups = builder.build();
        return MarketDataBox.ofScenarioValues((List)curveGroups);
    }

    private static List<RatesCurveInputs> inputsForScenario(List<MarketDataBox<RatesCurveInputs>> boxes, int scenarioIndex) {
        return (List)boxes.stream().map(box -> (RatesCurveInputs)box.getValue(scenarioIndex)).collect(Guavate.toImmutableList());
    }

    private MarketDataBox<RatesCurveGroup> buildSingleCurveGroup(RatesCurveGroupDefinition configuredGroup, RatesCurveCalibrator calibrator, LocalDate valuationDate, List<MarketDataBox<RatesCurveInputs>> inputBoxes, Map<ObservableId, LocalDateDoubleTimeSeries> fixings, ReferenceData refData) {
        RatesCurveGroupDefinition filteredGroup = configuredGroup.filtered(valuationDate, refData);
        List inputs = (List)inputBoxes.stream().map(MarketDataBox::getSingleValue).collect(Guavate.toImmutableList());
        MarketData inputValues = RatesCurveGroupMarketDataFunction.inputsByKey(valuationDate, inputs, fixings);
        RatesCurveGroup curveGroup = this.buildGroup(filteredGroup, calibrator, inputValues, refData);
        return MarketDataBox.ofSingleValue((Object)curveGroup);
    }

    private static MarketData inputsByKey(LocalDate valuationDate, List<RatesCurveInputs> inputs, Map<ObservableId, LocalDateDoubleTimeSeries> fixings) {
        HashMap marketDataMap = new HashMap();
        for (RatesCurveInputs input : inputs) {
            ImmutableMap inputMarketData = input.getMarketData();
            for (Map.Entry entry : inputMarketData.entrySet()) {
                Object existingValue = marketDataMap.get(entry.getKey());
                if (existingValue == null) {
                    marketDataMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (existingValue.equals(entry.getValue())) continue;
                throw new IllegalArgumentException(Messages.format((String)"Multiple unequal values found for identifier {}. Values: {} and {}", (Object[])new Object[]{entry.getKey(), existingValue, entry.getValue()}));
            }
        }
        return ImmutableMarketData.builder((LocalDate)valuationDate).values(marketDataMap).timeSeries(fixings).build();
    }

    private RatesCurveGroup buildGroup(RatesCurveGroupDefinition groupDefn, RatesCurveCalibrator calibrator, MarketData marketData, ReferenceData refData) {
        ImmutableRatesProvider calibratedProvider = calibrator.calibrate(groupDefn, marketData, refData);
        return RatesCurveGroup.of((CurveGroupName)groupDefn.getName(), (Map)calibratedProvider.getDiscountCurves(), (Map)calibratedProvider.getIndexCurves());
    }

    private static int scenarioCount(MarketDataBox<LocalDate> valuationDate, List<MarketDataBox<RatesCurveInputs>> curveInputBoxes) {
        int scenarioCount = 0;
        if (valuationDate.isScenarioValue()) {
            scenarioCount = valuationDate.getScenarioCount();
        }
        for (MarketDataBox<RatesCurveInputs> box : curveInputBoxes) {
            if (!box.isScenarioValue()) continue;
            int boxScenarioCount = box.getScenarioCount();
            if (scenarioCount == 0) {
                scenarioCount = boxScenarioCount;
                continue;
            }
            if (scenarioCount == boxScenarioCount) continue;
            throw new IllegalArgumentException(Messages.format((String)"All boxes must have the same number of scenarios, current count = {}, box {} has {}", (Object[])new Object[]{scenarioCount, box, box.getScenarioCount()}));
        }
        if (scenarioCount != 0) {
            return scenarioCount;
        }
        throw new IllegalArgumentException("Cannot count the scenarios, all data contained single values");
    }

    private MarketDataBox<RatesCurveInputs> curveInputs(CurveDefinition curveDefn, ScenarioMarketData marketData, CurveGroupName groupName, ObservableSource obsSource) {
        if (this.requiresMarketData(curveDefn)) {
            RatesCurveInputsId curveInputsId = RatesCurveInputsId.of((CurveGroupName)groupName, (CurveName)curveDefn.getName(), (ObservableSource)obsSource);
            return marketData.getValue((MarketDataId)curveInputsId);
        }
        return MarketDataBox.ofSingleValue((Object)RatesCurveInputs.builder().build());
    }

    private boolean requiresMarketData(CurveDefinition curveDefn) {
        return curveDefn.getNodes().stream().anyMatch(node -> !node.requirements().isEmpty());
    }
}

