/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveInputs;
import com.opengamma.strata.market.curve.RatesCurveInputsId;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

public final class RatesCurveInputsMarketDataFunction
implements MarketDataFunction<RatesCurveInputs, RatesCurveInputsId> {
    public MarketDataRequirements requirements(RatesCurveInputsId id, MarketDataConfig marketDataConfig) {
        RatesCurveGroupDefinition groupConfig = (RatesCurveGroupDefinition)marketDataConfig.get(RatesCurveGroupDefinition.class, (TypedString)id.getCurveGroupName());
        Optional optionalDefinition = groupConfig.findCurveDefinition(id.getCurveName());
        if (!optionalDefinition.isPresent()) {
            return MarketDataRequirements.empty();
        }
        CurveDefinition definition = (CurveDefinition)optionalDefinition.get();
        return MarketDataRequirements.builder().addValues(RatesCurveInputsMarketDataFunction.nodeRequirements((List<CurveDefinition>)ImmutableList.of((Object)definition))).build();
    }

    public MarketDataBox<RatesCurveInputs> build(RatesCurveInputsId id, MarketDataConfig marketDataConfig, ScenarioMarketData marketData, ReferenceData refData) {
        CurveGroupName groupName = id.getCurveGroupName();
        CurveName curveName = id.getCurveName();
        RatesCurveGroupDefinition groupDefn = (RatesCurveGroupDefinition)marketDataConfig.get(RatesCurveGroupDefinition.class, (TypedString)groupName);
        Optional optionalDefinition = groupDefn.findCurveDefinition(id.getCurveName());
        if (!optionalDefinition.isPresent()) {
            throw new IllegalArgumentException(Messages.format((String)"No curve named '{}' found in group '{}'", (Object[])new Object[]{curveName, groupName}));
        }
        CurveDefinition configuredDefn = (CurveDefinition)optionalDefinition.get();
        MarketDataBox valuationDates = marketData.getValuationDate();
        boolean multipleValuationDates = valuationDates.isScenarioValue();
        if (multipleValuationDates) {
            List curveDefns = (List)IntStream.range(0, valuationDates.getScenarioCount()).mapToObj(arg_0 -> ((MarketDataBox)valuationDates).getValue(arg_0)).map(valDate -> configuredDefn.filtered(valDate, refData)).collect(Guavate.toImmutableList());
            Set<MarketDataId<?>> requirements = RatesCurveInputsMarketDataFunction.nodeRequirements(curveDefns);
            Map marketDataValues = (Map)requirements.stream().collect(Guavate.toImmutableMap(k -> k, k -> marketData.getValue(k)));
            return this.buildMultipleCurveInputs((MarketDataBox<CurveDefinition>)MarketDataBox.ofScenarioValues((List)curveDefns), marketDataValues, (MarketDataBox<LocalDate>)valuationDates, refData);
        }
        LocalDate valuationDate = (LocalDate)valuationDates.getValue(0);
        CurveDefinition filteredDefn = configuredDefn.filtered(valuationDate, refData);
        Set<MarketDataId<?>> requirements = RatesCurveInputsMarketDataFunction.nodeRequirements((List<CurveDefinition>)ImmutableList.of((Object)filteredDefn));
        Map marketDataValues = (Map)requirements.stream().collect(Guavate.toImmutableMap(k -> k, k -> marketData.getValue(k)));
        boolean multipleInputValues = marketDataValues.values().stream().anyMatch(MarketDataBox::isScenarioValue);
        return multipleInputValues || multipleValuationDates ? this.buildMultipleCurveInputs((MarketDataBox<CurveDefinition>)MarketDataBox.ofSingleValue((Object)filteredDefn), marketDataValues, (MarketDataBox<LocalDate>)valuationDates, refData) : this.buildSingleCurveInputs(filteredDefn, marketDataValues, valuationDate, refData);
    }

    private MarketDataBox<RatesCurveInputs> buildSingleCurveInputs(CurveDefinition filteredDefn, Map<? extends MarketDataId<?>, MarketDataBox<?>> marketData, LocalDate valuationDate, ReferenceData refData) {
        CurveMetadata curveMetadata = filteredDefn.metadata(valuationDate, refData);
        ImmutableMap singleMarketDataValues = MapStream.of(marketData).mapValues(box -> box.getSingleValue()).toMap();
        RatesCurveInputs curveInputs = RatesCurveInputs.of((Map)singleMarketDataValues, (CurveMetadata)curveMetadata);
        return MarketDataBox.ofSingleValue((Object)curveInputs);
    }

    private MarketDataBox<RatesCurveInputs> buildMultipleCurveInputs(MarketDataBox<CurveDefinition> filteredDefns, Map<? extends MarketDataId<?>, MarketDataBox<?>> marketData, MarketDataBox<LocalDate> valuationDates, ReferenceData refData) {
        int scenarioCount = RatesCurveInputsMarketDataFunction.scenarioCount(valuationDates, marketData);
        ImmutableList.Builder curveMetadataBuilder = ImmutableList.builder();
        for (int i2 = 0; i2 < scenarioCount; ++i2) {
            LocalDate valDate = (LocalDate)valuationDates.getValue(i2);
            CurveDefinition defn = (CurveDefinition)filteredDefns.getValue(i2);
            curveMetadataBuilder.add((Object)defn.metadata(valDate, refData));
        }
        ImmutableList curveMetadata = curveMetadataBuilder.build();
        List scenarioValues = (List)IntStream.range(0, scenarioCount).mapToObj(i -> RatesCurveInputsMarketDataFunction.buildScenarioValues(marketData, i)).collect(Guavate.toImmutableList());
        List curveInputs = (List)Guavate.zip(scenarioValues.stream(), curveMetadata.stream()).map(pair -> RatesCurveInputs.of((Map)((Map)pair.getFirst()), (CurveMetadata)((CurveMetadata)pair.getSecond()))).collect(Guavate.toImmutableList());
        return MarketDataBox.ofScenarioValues((List)curveInputs);
    }

    private static Map<? extends MarketDataId<?>, ?> buildScenarioValues(Map<? extends MarketDataId<?>, MarketDataBox<?>> values, int scenarioIndex) {
        return MapStream.of(values).mapValues(box -> box.getValue(scenarioIndex)).toMap();
    }

    private static int scenarioCount(MarketDataBox<LocalDate> valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> marketData) {
        int scenarioCount = 0;
        if (valuationDate.isScenarioValue()) {
            scenarioCount = valuationDate.getScenarioCount();
        }
        for (Map.Entry<MarketDataId<?>, MarketDataBox<?>> entry : marketData.entrySet()) {
            MarketDataBox<?> box = entry.getValue();
            MarketDataId<?> id = entry.getKey();
            if (!box.isScenarioValue()) continue;
            int boxScenarioCount = box.getScenarioCount();
            if (scenarioCount == 0) {
                scenarioCount = boxScenarioCount;
                continue;
            }
            if (scenarioCount == boxScenarioCount) continue;
            throw new IllegalArgumentException(Messages.format((String)"There are {} scenarios for ID {} which does not match the previous scenario count {}", (Object[])new Object[]{boxScenarioCount, id, scenarioCount}));
        }
        if (scenarioCount != 0) {
            return scenarioCount;
        }
        throw new IllegalArgumentException("Cannot count the scenarios, all data contained single values");
    }

    public Class<RatesCurveInputsId> getMarketDataIdType() {
        return RatesCurveInputsId.class;
    }

    private static Set<MarketDataId<?>> nodeRequirements(List<CurveDefinition> curveDefns) {
        return (Set)curveDefns.stream().flatMap(defn -> defn.getNodes().stream()).flatMap(node -> node.requirements().stream()).collect(Guavate.toImmutableSet());
    }
}

