/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.calc.runner.FxRateLookup;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.RatesCurveGroup;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.curve.RatesCurveGroupEntry;
import com.opengamma.strata.measure.rate.DefaultRatesMarketData;
import com.opengamma.strata.measure.rate.DefaultRatesMarketDataLookup;
import com.opengamma.strata.measure.rate.DefaultRatesScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesMarketData;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface RatesMarketDataLookup
extends FxRateLookup,
CalculationParameter {
    public static RatesMarketDataLookup of(Map<Currency, CurveId> discountCurveIds, Map<Index, CurveId> forwardCurveIds) {
        return DefaultRatesMarketDataLookup.of(discountCurveIds, forwardCurveIds, ObservableSource.NONE, FxRateLookup.ofRates());
    }

    public static RatesMarketDataLookup of(Map<Currency, CurveId> discountCurveIds, Map<Index, CurveId> forwardCurveIds, ObservableSource obsSource, FxRateLookup fxLookup) {
        return DefaultRatesMarketDataLookup.of(discountCurveIds, forwardCurveIds, obsSource, fxLookup);
    }

    public static RatesMarketDataLookup of(CurveGroupName groupName, Map<Currency, CurveName> discountCurves, Map<? extends Index, CurveName> forwardCurves) {
        ImmutableMap discountCurveIds = MapStream.of(discountCurves).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c)).toMap();
        ImmutableMap forwardCurveIds = MapStream.of(forwardCurves).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c)).toMap();
        return DefaultRatesMarketDataLookup.of((Map<Currency, CurveId>)discountCurveIds, (Map<? extends Index, CurveId>)forwardCurveIds, ObservableSource.NONE, FxRateLookup.ofRates());
    }

    public static RatesMarketDataLookup of(RatesCurveGroup curveGroup) {
        CurveGroupName groupName = curveGroup.getName();
        ImmutableMap discountCurves = MapStream.of((Map)curveGroup.getDiscountCurves()).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c.getName())).toMap();
        ImmutableMap forwardCurves = MapStream.of((Map)curveGroup.getForwardCurves()).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c.getName())).toMap();
        return DefaultRatesMarketDataLookup.of((Map<Currency, CurveId>)discountCurves, (Map<? extends Index, CurveId>)forwardCurves, ObservableSource.NONE, FxRateLookup.ofRates());
    }

    public static RatesMarketDataLookup of(RatesCurveGroupDefinition curveGroupDefinition) {
        CurveGroupName groupName = curveGroupDefinition.getName();
        HashMap<Currency, CurveId> discountCurves = new HashMap<Currency, CurveId>();
        HashMap forwardCurves = new HashMap();
        for (RatesCurveGroupEntry entry : curveGroupDefinition.getEntries()) {
            CurveId curveId = CurveId.of((CurveGroupName)groupName, (CurveName)entry.getCurveName());
            entry.getDiscountCurrencies().forEach(ccy -> discountCurves.put((Currency)ccy, curveId));
            entry.getIndices().forEach(idx -> forwardCurves.put(idx, curveId));
        }
        return DefaultRatesMarketDataLookup.of(discountCurves, forwardCurves, ObservableSource.NONE, FxRateLookup.ofRates());
    }

    public static RatesMarketDataLookup of(RatesCurveGroupDefinition curveGroupDefinition, ObservableSource observableSource, FxRateLookup fxLookup) {
        CurveGroupName groupName = curveGroupDefinition.getName();
        HashMap<Currency, CurveId> discountCurves = new HashMap<Currency, CurveId>();
        HashMap forwardCurves = new HashMap();
        for (RatesCurveGroupEntry entry : curveGroupDefinition.getEntries()) {
            CurveId curveId = CurveId.of((CurveGroupName)groupName, (CurveName)entry.getCurveName(), (ObservableSource)observableSource);
            entry.getDiscountCurrencies().forEach(ccy -> discountCurves.put((Currency)ccy, curveId));
            entry.getIndices().forEach(idx -> forwardCurves.put(idx, curveId));
        }
        return DefaultRatesMarketDataLookup.of(discountCurves, forwardCurves, observableSource, fxLookup);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return RatesMarketDataLookup.class;
    }

    public ImmutableSet<Currency> getDiscountCurrencies();

    public ImmutableSet<MarketDataId<?>> getDiscountMarketDataIds(Currency var1);

    public ImmutableSet<Index> getForwardIndices();

    public ImmutableSet<MarketDataId<?>> getForwardMarketDataIds(Index var1);

    default public FunctionRequirements requirements(Set<Currency> currencies) {
        return this.requirements(currencies, (Set<? extends Index>)ImmutableSet.of());
    }

    default public FunctionRequirements requirements(Currency currency, Index ... indices) {
        return this.requirements((Set<Currency>)ImmutableSet.of((Object)currency), (Set<? extends Index>)ImmutableSet.copyOf((Object[])indices));
    }

    public FunctionRequirements requirements(Set<Currency> var1, Set<? extends Index> var2);

    default public RatesScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultRatesScenarioMarketData.of(this, marketData);
    }

    default public RatesMarketData marketDataView(MarketData marketData) {
        return DefaultRatesMarketData.of(this, marketData);
    }

    public RatesProvider ratesProvider(MarketData var1);

    public FxRateProvider fxRateProvider(MarketData var1);

    default public ObservableSource getObservableSource() {
        return ObservableSource.NONE;
    }

    default public FxRateLookup getFxRateLookup() {
        return this;
    }
}

