/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.security.SecurityMeasureCalculations;
import com.opengamma.strata.product.GenericSecurityPosition;
import com.opengamma.strata.product.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GenericSecurityPositionCalculationFunction
implements CalculationFunction<GenericSecurityPosition> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, SecurityMeasureCalculations::presentValue).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<GenericSecurityPosition> targetType() {
        return GenericSecurityPosition.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(GenericSecurityPosition target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(GenericSecurityPosition position, ReferenceData refData) {
        return position.getCurrency();
    }

    public FunctionRequirements requirements(GenericSecurityPosition position, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        QuoteId id = QuoteId.of((StandardId)position.getSecurityId().getStandardId());
        return FunctionRequirements.builder().valueRequirements((Set)ImmutableSet.of((Object)id)).outputCurrencies(new Currency[]{position.getCurrency()}).build();
    }

    public Map<Measure, Result<?>> calculate(GenericSecurityPosition position, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, position, scenarioMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, GenericSecurityPosition position, ScenarioMarketData scenarioMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for GenericSecurityPosition: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate((Security)position.getSecurity(), position.getQuantity(), scenarioMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public ScenarioArray<?> calculate(Security var1, double var2, ScenarioMarketData var4);
    }
}

