/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.security.SecurityMeasureCalculations;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SecurityTradeCalculationFunction
implements CalculationFunction<SecurityTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, SecurityMeasureCalculations::presentValue).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<SecurityTrade> targetType() {
        return SecurityTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(SecurityTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(SecurityTrade trade, ReferenceData refData) {
        Security security = (Security)refData.getValue((ReferenceDataId)trade.getSecurityId());
        return security.getCurrency();
    }

    public FunctionRequirements requirements(SecurityTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        Security security = (Security)refData.getValue((ReferenceDataId)trade.getSecurityId());
        QuoteId id = QuoteId.of((StandardId)trade.getSecurityId().getStandardId());
        return FunctionRequirements.builder().valueRequirements((Set)ImmutableSet.of((Object)id)).outputCurrencies(new Currency[]{security.getCurrency()}).build();
    }

    public Map<Measure, Result<?>> calculate(SecurityTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        Security security = (Security)refData.getValue((ReferenceDataId)trade.getSecurityId());
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, trade, security, scenarioMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, SecurityTrade trade, Security security, ScenarioMarketData scenarioMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for SecurityTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(security, trade.getQuantity(), scenarioMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public ScenarioArray<?> calculate(Security var1, double var2, ScenarioMarketData var4);
    }
}

