/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swap;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.amount.LegAmounts;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.swap.SwapMeasureCalculations;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapTradePricer;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;

public class SwapTradeCalculations {
    public static final SwapTradeCalculations DEFAULT = new SwapTradeCalculations(DiscountingSwapTradePricer.DEFAULT);
    private final SwapMeasureCalculations calc;

    public SwapTradeCalculations(DiscountingSwapTradePricer tradePricer) {
        this.calc = new SwapMeasureCalculations(tradePricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount presentValue(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public ScenarioArray<ExplainMap> explainPresentValue(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.explainPresentValue(trade, lookup.marketDataView(marketData));
    }

    public ExplainMap explainPresentValue(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.explainPresentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parRate(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parRate(trade, lookup.marketDataView(marketData));
    }

    public double parRate(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.parRate(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.parSpread(trade, ratesProvider);
    }

    public ScenarioArray<CashFlows> cashFlows(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.cashFlows(trade, lookup.marketDataView(marketData));
    }

    public CashFlows cashFlows(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.cashFlows(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray accruedInterest(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.accruedInterest(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount accruedInterest(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.accruedInterest(trade, ratesProvider);
    }

    public LegAmounts legInitialNotional(ResolvedSwapTrade trade) {
        return this.calc.legInitialNotional(trade);
    }

    public ScenarioArray<LegAmounts> legPresentValue(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.legPresentValue(trade, lookup.marketDataView(marketData));
    }

    public LegAmounts legPresentValue(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.legPresentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currentCash(ResolvedSwapTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currentCash(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }
}

