/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swaption;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.measure.swaption.SwaptionMarketDataLookup;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultSwaptionMarketDataLookup
implements SwaptionMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<RateIndex, SwaptionVolatilitiesId> volatilityIds;
    private static final TypedMetaBean<DefaultSwaptionMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultSwaptionMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"volatilityIds"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static DefaultSwaptionMarketDataLookup of(RateIndex index, SwaptionVolatilitiesId volatilityId) {
        return new DefaultSwaptionMarketDataLookup((Map<RateIndex, SwaptionVolatilitiesId>)ImmutableMap.of((Object)index, (Object)volatilityId));
    }

    public static DefaultSwaptionMarketDataLookup of(Map<RateIndex, SwaptionVolatilitiesId> volatilityIds) {
        return new DefaultSwaptionMarketDataLookup(volatilityIds);
    }

    @Override
    public ImmutableSet<RateIndex> getVolatilityIndices() {
        return this.volatilityIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getVolatilityIds(RateIndex index) {
        SwaptionVolatilitiesId id = (SwaptionVolatilitiesId)this.volatilityIds.get((Object)index);
        if (id == null) {
            throw new IllegalArgumentException(this.msgIndexNotFound(index));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(Set<RateIndex> indices) {
        ImmutableSet.Builder requiredIndices = ImmutableSet.builder();
        for (RateIndex index : indices) {
            if (!this.volatilityIds.containsKey((Object)index)) {
                throw new IllegalArgumentException(this.msgIndexNotFound(index));
            }
            requiredIndices.add(Objects.requireNonNull(this.volatilityIds.get((Object)index)));
        }
        return FunctionRequirements.builder().valueRequirements((Set)requiredIndices.build()).build();
    }

    @Override
    public SwaptionVolatilities volatilities(RateIndex index, MarketData marketData) {
        SwaptionVolatilitiesId volatilityId = (SwaptionVolatilitiesId)this.volatilityIds.get((Object)index);
        if (volatilityId == null) {
            throw new MarketDataNotFoundException(this.msgIndexNotFound(index));
        }
        return (SwaptionVolatilities)marketData.getValue((MarketDataId)volatilityId);
    }

    private String msgIndexNotFound(RateIndex index) {
        return Messages.format((String)"Swaption lookup has no volatilities defined for index '{}'", (Object)index);
    }

    public static TypedMetaBean<DefaultSwaptionMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultSwaptionMarketDataLookup(Map<RateIndex, SwaptionVolatilitiesId> volatilityIds) {
        JodaBeanUtils.notNull(volatilityIds, (String)"volatilityIds");
        this.volatilityIds = ImmutableMap.copyOf(volatilityIds);
    }

    public TypedMetaBean<DefaultSwaptionMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<RateIndex, SwaptionVolatilitiesId> getVolatilityIds() {
        return this.volatilityIds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultSwaptionMarketDataLookup other = (DefaultSwaptionMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.volatilityIds, other.volatilityIds);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.volatilityIds);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultSwaptionMarketDataLookup{");
        buf.append("volatilityIds").append('=').append(JodaBeanUtils.toString(this.volatilityIds));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

