/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.bond.BondFutureOptionScenarioMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.pricer.bond.BlackBondFutureOptionMarginedTradePricer;
import com.opengamma.strata.pricer.bond.BlackBondFutureVolatilities;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.bond.ResolvedBondFutureOptionTrade;

final class BondFutureOptionMeasureCalculations {
    public static final BondFutureOptionMeasureCalculations DEFAULT = new BondFutureOptionMeasureCalculations(BlackBondFutureOptionMarginedTradePricer.DEFAULT);
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final BlackBondFutureOptionMarginedTradePricer tradePricer;

    BondFutureOptionMeasureCalculations(BlackBondFutureOptionMarginedTradePricer tradePricer) {
        this.tradePricer = (BlackBondFutureOptionMarginedTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingScenarioMarketData legalEntityMarketData, BondFutureOptionScenarioMarketData optionMarketData) {
        SecurityId securityId = trade.getProduct().getUnderlyingFuture().getSecurityId();
        return CurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.presentValue(trade, legalEntityMarketData.scenario(i).discountingProvider(), optionMarketData.scenario(i).volatilities(securityId)));
    }

    CurrencyAmount presentValue(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        double settlementPrice = this.settlementPrice(trade, discountingProvider);
        BlackBondFutureVolatilities normalVols = this.checkBlackVols(volatilities);
        return this.tradePricer.presentValue(trade, discountingProvider, (BondFutureVolatilities)normalVols, settlementPrice);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingScenarioMarketData legalEntityMarketData, BondFutureOptionScenarioMarketData optionMarketData) {
        SecurityId securityId = trade.getProduct().getUnderlyingFuture().getSecurityId();
        return MultiCurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, legalEntityMarketData.scenario(i).discountingProvider(), optionMarketData.scenario(i).volatilities(securityId)));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        BlackBondFutureVolatilities normalVols = this.checkBlackVols(volatilities);
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivityRates(trade, discountingProvider, (BondFutureVolatilities)normalVols);
        return discountingProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingScenarioMarketData legalEntityMarketData, BondFutureOptionScenarioMarketData optionMarketData) {
        SecurityId securityId = trade.getProduct().getUnderlyingFuture().getSecurityId();
        return ScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, legalEntityMarketData.scenario(i).discountingProvider(), optionMarketData.scenario(i).volatilities(securityId)));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        BlackBondFutureVolatilities normalVols = this.checkBlackVols(volatilities);
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivityRates(trade, discountingProvider, (BondFutureVolatilities)normalVols);
        return discountingProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    DoubleScenarioArray unitPrice(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingScenarioMarketData legalEntityMarketData, BondFutureOptionScenarioMarketData optionMarketData) {
        SecurityId securityId = trade.getProduct().getUnderlyingFuture().getSecurityId();
        return DoubleScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.unitPrice(trade, legalEntityMarketData.scenario(i).discountingProvider(), optionMarketData.scenario(i).volatilities(securityId)));
    }

    double unitPrice(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        BlackBondFutureVolatilities normalVols = this.checkBlackVols(volatilities);
        return this.tradePricer.price(trade, discountingProvider, (BondFutureVolatilities)normalVols);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingScenarioMarketData legalEntityMarketData, BondFutureOptionScenarioMarketData optionMarketData) {
        SecurityId securityId = trade.getProduct().getUnderlyingFuture().getSecurityId();
        return MultiCurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.currencyExposure(trade, legalEntityMarketData.scenario(i).discountingProvider(), optionMarketData.scenario(i).volatilities(securityId)));
    }

    MultiCurrencyAmount currencyExposure(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        double settlementPrice = this.settlementPrice(trade, discountingProvider);
        return this.tradePricer.currencyExposure(trade, discountingProvider, volatilities, settlementPrice);
    }

    private double settlementPrice(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        StandardId standardId = trade.getProduct().getSecurityId().getStandardId();
        QuoteId id = QuoteId.of((StandardId)standardId, (FieldName)FieldName.SETTLEMENT_PRICE);
        return (Double)discountingProvider.data((MarketDataId)id);
    }

    private BlackBondFutureVolatilities checkBlackVols(BondFutureVolatilities volatilities) {
        if (volatilities instanceof BlackBondFutureVolatilities) {
            return (BlackBondFutureVolatilities)volatilities;
        }
        throw new IllegalArgumentException(Messages.format((String)"Bond future option only supports Black volatilities, but was '{}'", (Object)volatilities.getVolatilityType()));
    }
}

