/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.bond.DiscountingCapitalIndexedBondTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondTrade;

final class CapitalIndexedBondMeasureCalculations {
    public static final CapitalIndexedBondMeasureCalculations DEFAULT = new CapitalIndexedBondMeasureCalculations(DiscountingCapitalIndexedBondTradePricer.DEFAULT);
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingCapitalIndexedBondTradePricer tradePricer;

    CapitalIndexedBondMeasureCalculations(DiscountingCapitalIndexedBondTradePricer tradePricer) {
        this.tradePricer = (DiscountingCapitalIndexedBondTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedCapitalIndexedBondTrade trade, RatesScenarioMarketData ratesMarketData, LegalEntityDiscountingScenarioMarketData legalEntityMarketData) {
        return CurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), legalEntityMarketData.scenario(i).discountingProvider()));
    }

    CurrencyAmount presentValue(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.presentValue(trade, ratesProvider, discountingProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedCapitalIndexedBondTrade trade, RatesScenarioMarketData ratesMarketData, LegalEntityDiscountingScenarioMarketData legalEntityMarketData) {
        return MultiCurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), legalEntityMarketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedCapitalIndexedBondTrade trade, RatesScenarioMarketData ratesMarketData, LegalEntityDiscountingScenarioMarketData legalEntityMarketData) {
        return ScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), legalEntityMarketData.scenario(i).discountingProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider, discountingProvider);
        return discountingProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedCapitalIndexedBondTrade trade, RatesScenarioMarketData ratesMarketData, LegalEntityDiscountingScenarioMarketData legalEntityMarketData) {
        return MultiCurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.currencyExposure(trade, ratesMarketData.scenario(i).ratesProvider(), legalEntityMarketData.scenario(i).discountingProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        return this.tradePricer.currencyExposure(trade, ratesProvider, discountingProvider);
    }

    CurrencyScenarioArray currentCash(ResolvedCapitalIndexedBondTrade trade, RatesScenarioMarketData ratesMarketData, LegalEntityDiscountingScenarioMarketData legalEntityMarketData) {
        return CurrencyScenarioArray.of((int)legalEntityMarketData.getScenarioCount(), i -> this.currentCash(trade, ratesMarketData.scenario(i).ratesProvider()));
    }

    CurrencyAmount currentCash(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currentCash(trade, ratesProvider);
    }
}

