/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.bond.CapitalIndexedBondMeasureCalculations;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.bond.DiscountingCapitalIndexedBondTradePricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondTrade;

public class CapitalIndexedBondTradeCalculations {
    public static final CapitalIndexedBondTradeCalculations DEFAULT = new CapitalIndexedBondTradeCalculations(DiscountingCapitalIndexedBondTradePricer.DEFAULT);
    private final CapitalIndexedBondMeasureCalculations calc;

    public CapitalIndexedBondTradeCalculations(DiscountingCapitalIndexedBondTradePricer tradePricer) {
        this.calc = new CapitalIndexedBondMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedCapitalIndexedBondTrade trade, RatesMarketDataLookup ratesLookup, LegalEntityDiscountingMarketDataLookup legalEntityLookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), legalEntityLookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider legalEntityProvider) {
        return this.calc.presentValue(trade, ratesProvider, legalEntityProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedCapitalIndexedBondTrade trade, RatesMarketDataLookup ratesLookup, LegalEntityDiscountingMarketDataLookup legalEntityLookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, ratesLookup.marketDataView(marketData), legalEntityLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider legalEntityProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider, legalEntityProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedCapitalIndexedBondTrade trade, RatesMarketDataLookup ratesLookup, LegalEntityDiscountingMarketDataLookup legalEntityLookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, ratesLookup.marketDataView(marketData), legalEntityLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider legalEntityProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider, legalEntityProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedCapitalIndexedBondTrade trade, RatesMarketDataLookup ratesLookup, LegalEntityDiscountingMarketDataLookup legalEntityLookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, ratesLookup.marketDataView(marketData), legalEntityLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider legalEntityProvider) {
        return this.calc.currencyExposure(trade, ratesProvider, legalEntityProvider);
    }

    public CurrencyScenarioArray currentCash(ResolvedCapitalIndexedBondTrade trade, RatesMarketDataLookup ratesLookup, LegalEntityDiscountingMarketDataLookup legalEntityLookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, ratesLookup.marketDataView(marketData), legalEntityLookup.marketDataView(marketData));
    }

    public CurrencyAmount currentCash(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider legalEntityProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }
}

