/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultLegalEntityDiscountingMarketData
implements LegalEntityDiscountingMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LegalEntityDiscountingMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private final transient LegalEntityDiscountingProvider discountingProvider;
    private static final TypedMetaBean<DefaultLegalEntityDiscountingMarketData> META_BEAN = LightMetaBean.of(DefaultLegalEntityDiscountingMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    static DefaultLegalEntityDiscountingMarketData of(LegalEntityDiscountingMarketDataLookup lookup, MarketData marketData) {
        return new DefaultLegalEntityDiscountingMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultLegalEntityDiscountingMarketData(LegalEntityDiscountingMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (LegalEntityDiscountingMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.discountingProvider = lookup.discountingProvider(marketData);
    }

    private Object readResolve() {
        return new DefaultLegalEntityDiscountingMarketData(this.lookup, this.marketData);
    }

    @Override
    public LegalEntityDiscountingMarketData withMarketData(MarketData marketData) {
        return DefaultLegalEntityDiscountingMarketData.of(this.lookup, marketData);
    }

    @Override
    public LegalEntityDiscountingProvider discountingProvider() {
        return this.discountingProvider;
    }

    public static TypedMetaBean<DefaultLegalEntityDiscountingMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultLegalEntityDiscountingMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public LegalEntityDiscountingMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultLegalEntityDiscountingMarketData other = (DefaultLegalEntityDiscountingMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultLegalEntityDiscountingMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

