/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultLegalEntityDiscountingScenarioMarketData
implements LegalEntityDiscountingScenarioMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LegalEntityDiscountingMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ScenarioMarketData marketData;
    private final transient AtomicReferenceArray<LegalEntityDiscountingMarketData> cache;
    private static final TypedMetaBean<DefaultLegalEntityDiscountingScenarioMarketData> META_BEAN = LightMetaBean.of(DefaultLegalEntityDiscountingScenarioMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    static DefaultLegalEntityDiscountingScenarioMarketData of(LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        return new DefaultLegalEntityDiscountingScenarioMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultLegalEntityDiscountingScenarioMarketData(LegalEntityDiscountingMarketDataLookup lookup, ScenarioMarketData marketData) {
        this.lookup = (LegalEntityDiscountingMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (ScenarioMarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.cache = new AtomicReferenceArray(marketData.getScenarioCount());
    }

    private Object readResolve() {
        return new DefaultLegalEntityDiscountingScenarioMarketData(this.lookup, this.marketData);
    }

    @Override
    public LegalEntityDiscountingScenarioMarketData withMarketData(ScenarioMarketData marketData) {
        return DefaultLegalEntityDiscountingScenarioMarketData.of(this.lookup, marketData);
    }

    @Override
    public int getScenarioCount() {
        return this.marketData.getScenarioCount();
    }

    @Override
    public LegalEntityDiscountingMarketData scenario(int scenarioIndex) {
        LegalEntityDiscountingMarketData current = this.cache.get(scenarioIndex);
        if (current != null) {
            return current;
        }
        return this.cache.updateAndGet(scenarioIndex, v -> v != null ? v : this.lookup.marketDataView(this.marketData.scenario(scenarioIndex)));
    }

    public static TypedMetaBean<DefaultLegalEntityDiscountingScenarioMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultLegalEntityDiscountingScenarioMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public LegalEntityDiscountingMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public ScenarioMarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultLegalEntityDiscountingScenarioMarketData other = (DefaultLegalEntityDiscountingScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultLegalEntityDiscountingScenarioMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

