/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.bond;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.LegalEntityCurveGroup;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.curve.RepoGroup;
import com.opengamma.strata.measure.bond.DefaultLegalEntityDiscountingMarketData;
import com.opengamma.strata.measure.bond.DefaultLegalEntityDiscountingMarketDataLookup;
import com.opengamma.strata.measure.bond.DefaultLegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingMarketData;
import com.opengamma.strata.measure.bond.LegalEntityDiscountingScenarioMarketData;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecurityId;
import java.util.Map;

public interface LegalEntityDiscountingMarketDataLookup
extends CalculationParameter {
    public static LegalEntityDiscountingMarketDataLookup of(Map<SecurityId, RepoGroup> repoCurveSecurityGroups, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurveIds) {
        return DefaultLegalEntityDiscountingMarketDataLookup.of(repoCurveSecurityGroups, repoCurveGroups, repoCurveIds, issuerCurveGroups, issuerCurveIds, ObservableSource.NONE);
    }

    public static LegalEntityDiscountingMarketDataLookup of(Map<SecurityId, RepoGroup> repoCurveSecurityGroups, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurveIds, ObservableSource obsSource) {
        return DefaultLegalEntityDiscountingMarketDataLookup.of(repoCurveSecurityGroups, repoCurveGroups, repoCurveIds, issuerCurveGroups, issuerCurveIds, obsSource);
    }

    public static LegalEntityDiscountingMarketDataLookup of(Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurveIds) {
        return DefaultLegalEntityDiscountingMarketDataLookup.of((Map<SecurityId, RepoGroup>)ImmutableMap.of(), repoCurveGroups, repoCurveIds, issuerCurveGroups, issuerCurveIds, ObservableSource.NONE);
    }

    public static LegalEntityDiscountingMarketDataLookup of(Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, CurveId> issuerCurveIds, ObservableSource obsSource) {
        return DefaultLegalEntityDiscountingMarketDataLookup.of((Map<SecurityId, RepoGroup>)ImmutableMap.of(), repoCurveGroups, repoCurveIds, issuerCurveGroups, issuerCurveIds, obsSource);
    }

    public static LegalEntityDiscountingMarketDataLookup of(LegalEntityCurveGroup curveGroup, Map<SecurityId, RepoGroup> repoCurveSecurityGroups, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups) {
        CurveGroupName groupName = curveGroup.getName();
        ImmutableMap repoCurveIds = MapStream.of((Map)curveGroup.getRepoCurves()).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c.getName())).toMap();
        ImmutableMap issuerCurveIds = MapStream.of((Map)curveGroup.getIssuerCurves()).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c.getName())).toMap();
        return DefaultLegalEntityDiscountingMarketDataLookup.of(repoCurveSecurityGroups, repoCurveGroups, (Map<Pair<RepoGroup, Currency>, CurveId>)repoCurveIds, issuerCurveGroups, (Map<Pair<LegalEntityGroup, Currency>, CurveId>)issuerCurveIds, ObservableSource.NONE);
    }

    public static LegalEntityDiscountingMarketDataLookup of(LegalEntityCurveGroup curveGroup, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups) {
        return LegalEntityDiscountingMarketDataLookup.of(curveGroup, (Map<SecurityId, RepoGroup>)ImmutableMap.of(), repoCurveGroups, issuerCurveGroups);
    }

    public static LegalEntityDiscountingMarketDataLookup of(Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds) {
        return LegalEntityDiscountingMarketDataLookup.of(repoCurveGroups, repoCurveIds, ObservableSource.NONE);
    }

    public static LegalEntityDiscountingMarketDataLookup of(Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, CurveId> repoCurveIds, ObservableSource obsSource) {
        return DefaultLegalEntityDiscountingMarketDataLookup.of(repoCurveGroups, repoCurveIds, obsSource);
    }

    public static LegalEntityDiscountingMarketDataLookup of(LegalEntityCurveGroup curveGroup, Map<LegalEntityId, RepoGroup> repoCurveGroups) {
        CurveGroupName groupName = curveGroup.getName();
        ImmutableMap repoCurveIds = MapStream.of((Map)curveGroup.getRepoCurves()).mapValues(c -> CurveId.of((CurveGroupName)groupName, (CurveName)c.getName())).toMap();
        return LegalEntityDiscountingMarketDataLookup.of(repoCurveGroups, (Map<Pair<RepoGroup, Currency>, CurveId>)repoCurveIds, ObservableSource.NONE);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return LegalEntityDiscountingMarketDataLookup.class;
    }

    public FunctionRequirements requirements(SecurityId var1, LegalEntityId var2, Currency var3);

    public FunctionRequirements requirements(LegalEntityId var1, Currency var2);

    default public LegalEntityDiscountingScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultLegalEntityDiscountingScenarioMarketData.of(this, marketData);
    }

    default public LegalEntityDiscountingMarketData marketDataView(MarketData marketData) {
        return DefaultLegalEntityDiscountingMarketData.of(this, marketData);
    }

    public LegalEntityDiscountingProvider discountingProvider(MarketData var1);
}

