/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.calc;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class TargetTypeCalculationParameter
implements CalculationParameter,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Class<? extends CalculationParameter> queryType;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Class<?>, CalculationParameter> parameters;
    @PropertyDefinition(validate="notNull")
    private final CalculationParameter defaultParameter;
    private static final TypedMetaBean<TargetTypeCalculationParameter> META_BEAN = LightMetaBean.of(TargetTypeCalculationParameter.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"queryType", "parameters", "defaultParameter"}, (Object[])new Object[]{null, ImmutableMap.of(), null});
    private static final long serialVersionUID = 1L;

    public static TargetTypeCalculationParameter of(Map<Class<?>, CalculationParameter> parameters, CalculationParameter defaultParameter) {
        ArgChecker.notEmpty(parameters, (String)"values");
        ArgChecker.notNull((Object)defaultParameter, (String)"defaultValue");
        Class queryType = defaultParameter.queryType();
        for (CalculationParameter value : parameters.values()) {
            if (value.queryType() == queryType) continue;
            throw new IllegalArgumentException(Messages.format((String)"Map contained a parameter '{}' that did not match the expected query type '{}'", (Object[])new Object[]{value, queryType.getClass().getSimpleName()}));
        }
        return new TargetTypeCalculationParameter(queryType, (Map<Class<?>, CalculationParameter>)ImmutableMap.copyOf(parameters), defaultParameter);
    }

    public Class<? extends CalculationParameter> queryType() {
        return this.queryType;
    }

    public Optional<CalculationParameter> filter(CalculationTarget target, Measure measure) {
        CalculationParameter value = (CalculationParameter)this.parameters.getOrDefault(target.getClass(), (Object)this.defaultParameter);
        return value.filter(target, measure);
    }

    public static TypedMetaBean<TargetTypeCalculationParameter> meta() {
        return META_BEAN;
    }

    private TargetTypeCalculationParameter(Class<? extends CalculationParameter> queryType, Map<Class<?>, CalculationParameter> parameters, CalculationParameter defaultParameter) {
        JodaBeanUtils.notNull(queryType, (String)"queryType");
        JodaBeanUtils.notNull(parameters, (String)"parameters");
        JodaBeanUtils.notNull((Object)defaultParameter, (String)"defaultParameter");
        this.queryType = queryType;
        this.parameters = ImmutableMap.copyOf(parameters);
        this.defaultParameter = defaultParameter;
    }

    public TypedMetaBean<TargetTypeCalculationParameter> metaBean() {
        return META_BEAN;
    }

    public Class<? extends CalculationParameter> getQueryType() {
        return this.queryType;
    }

    public ImmutableMap<Class<?>, CalculationParameter> getParameters() {
        return this.parameters;
    }

    public CalculationParameter getDefaultParameter() {
        return this.defaultParameter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TargetTypeCalculationParameter other = (TargetTypeCalculationParameter)obj;
            return JodaBeanUtils.equal(this.queryType, other.queryType) && JodaBeanUtils.equal(this.parameters, other.parameters) && JodaBeanUtils.equal((Object)this.defaultParameter, (Object)other.defaultParameter);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.queryType);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.defaultParameter);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("TargetTypeCalculationParameter{");
        buf.append("queryType").append('=').append(JodaBeanUtils.toString(this.queryType)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString(this.parameters)).append(',').append(' ');
        buf.append("defaultParameter").append('=').append(JodaBeanUtils.toString((Object)this.defaultParameter));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

