/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.credit;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.credit.CreditRatesScenarioMarketData;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.AnalyticSpreadSensitivityCalculator;
import com.opengamma.strata.pricer.credit.CdsMarketQuoteConverter;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaHomogenousCdsIndexTradePricer;
import com.opengamma.strata.pricer.credit.JumpToDefault;
import com.opengamma.strata.pricer.credit.SpreadSensitivityCalculator;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.credit.ResolvedCdsIndexTrade;

final class CdsIndexMeasureCalculations {
    public static final CdsIndexMeasureCalculations DEFAULT = new CdsIndexMeasureCalculations(new IsdaHomogenousCdsIndexTradePricer(AccrualOnDefaultFormula.CORRECT));
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final IsdaHomogenousCdsIndexTradePricer tradePricer;
    private final SpreadSensitivityCalculator cs01Calculator;
    private final CdsMarketQuoteConverter converter;

    public CdsIndexMeasureCalculations(IsdaHomogenousCdsIndexTradePricer tradePricer) {
        this.tradePricer = (IsdaHomogenousCdsIndexTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
        this.cs01Calculator = new AnalyticSpreadSensitivityCalculator(tradePricer.getAccrualOnDefaultFormula());
        this.converter = new CdsMarketQuoteConverter(tradePricer.getAccrualOnDefaultFormula());
    }

    CurrencyScenarioArray presentValue(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).creditRatesProvider(), PriceType.DIRTY, refData));
    }

    CurrencyAmount presentValue(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        return this.tradePricer.presentValue(trade, ratesProvider, priceType, refData);
    }

    CurrencyScenarioArray principal(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.principal(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyAmount principal(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return this.tradePricer.presentValueOnSettle(trade, ratesProvider, PriceType.CLEAN, refData);
    }

    DoubleScenarioArray unitPrice(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.unitPrice(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    double unitPrice(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        double puf = this.tradePricer.price(trade, ratesProvider, PriceType.CLEAN, refData);
        return this.converter.cleanPriceFromPointsUpfront(puf);
    }

    CurrencyScenarioArray ir01CalibratedParallel(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.ir01CalibratedParallel(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyAmount ir01CalibratedParallel(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueOnSettleSensitivity(trade, ratesProvider, refData);
        CurrencyParameterSensitivity irSensitivity = ratesProvider.singleDiscountCurveParameterSensitivity(pointSensitivity, trade.getProduct().getCurrency());
        return irSensitivity.total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivity> ir01CalibratedBucketed(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.ir01CalibratedBucketed(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyParameterSensitivity ir01CalibratedBucketed(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueOnSettleSensitivity(trade, ratesProvider, refData);
        CurrencyParameterSensitivity irSensitivity = ratesProvider.singleDiscountCurveParameterSensitivity(pointSensitivity, trade.getProduct().getCurrency());
        return irSensitivity.multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray ir01MarketQuoteParallel(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.ir01MarketQuoteParallel(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    MultiCurrencyAmount ir01MarketQuoteParallel(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueOnSettleSensitivity(trade, ratesProvider, refData);
        CurrencyParameterSensitivity parameterSensitivity = ratesProvider.singleDiscountCurveParameterSensitivity(pointSensitivity, trade.getProduct().getCurrency());
        CurrencyParameterSensitivities irSensitivity = MARKET_QUOTE_SENS.sensitivity(CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)parameterSensitivity), ratesProvider);
        return irSensitivity.total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> ir01MarketQuoteBucketed(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.ir01MarketQuoteBucketed(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyParameterSensitivities ir01MarketQuoteBucketed(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueOnSettleSensitivity(trade, ratesProvider, refData);
        CurrencyParameterSensitivity parameterSensitivity = ratesProvider.singleDiscountCurveParameterSensitivity(pointSensitivity, trade.getProduct().getCurrency());
        CurrencyParameterSensitivities irSensitivity = MARKET_QUOTE_SENS.sensitivity(CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)parameterSensitivity), ratesProvider);
        return irSensitivity.multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider, refData);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider, refData);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider, refData);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        CurrencyParameterSensitivities quoteSensitivity = MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider);
        return quoteSensitivity.total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider, refData);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    CurrencyScenarioArray cs01Parallel(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.cs01Parallel(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyAmount cs01Parallel(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return this.cs01Calculator.parallelCs01(trade, ratesProvider, refData);
    }

    ScenarioArray<CurrencyParameterSensitivity> cs01Bucketed(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.cs01Bucketed(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyParameterSensitivity cs01Bucketed(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return this.cs01Calculator.bucketedCs01(trade, ratesProvider, refData);
    }

    CurrencyScenarioArray recovery01(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.recovery01(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    CurrencyAmount recovery01(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return this.tradePricer.recovery01OnSettle(trade, ratesProvider, refData);
    }

    ScenarioArray<JumpToDefault> jumpToDefault(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.jumpToDefault(trade, marketData.scenario(i).creditRatesProvider(), refData));
    }

    JumpToDefault jumpToDefault(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return this.tradePricer.jumpToDefault(trade, ratesProvider, refData);
    }

    CurrencyScenarioArray expectedLoss(ResolvedCdsIndexTrade trade, CreditRatesScenarioMarketData marketData, ReferenceData refData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.expectedLoss(trade, marketData.scenario(i).creditRatesProvider()));
    }

    CurrencyAmount expectedLoss(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider) {
        return this.tradePricer.expectedLoss(trade, ratesProvider);
    }
}

