/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.credit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.measure.credit.CreditRatesMarketDataLookup;
import com.opengamma.strata.measure.credit.DefaultLookupCreditRatesProvider;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultCreditRatesMarketDataLookup
implements CreditRatesMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<StandardId, Currency>, CurveId> creditCurveIds;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Currency, CurveId> discountCurveIds;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<StandardId, CurveId> recoveryRateCurveIds;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource observableSource;
    private static final TypedMetaBean<DefaultCreditRatesMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultCreditRatesMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"creditCurveIds", "discountCurveIds", "recoveryRateCurveIds", "observableSource"}, (Object[])new Object[]{ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), null});
    private static final long serialVersionUID = 1L;

    static DefaultCreditRatesMarketDataLookup of(Map<Pair<StandardId, Currency>, CurveId> creditCurveIds, Map<Currency, CurveId> discountCurveIds, Map<StandardId, CurveId> recoveryRateCurveIds, ObservableSource observableSource) {
        return new DefaultCreditRatesMarketDataLookup(creditCurveIds, discountCurveIds, recoveryRateCurveIds, observableSource);
    }

    @Override
    public ImmutableSet<Currency> getDiscountCurrencies() {
        return this.discountCurveIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getDiscountMarketDataIds(Currency currency) {
        CurveId id = (CurveId)this.discountCurveIds.get((Object)currency);
        if (id == null) {
            throw new IllegalArgumentException(Messages.format((String)"Credit rates lookup has no discount curve defined for currency '{}'", (Object)currency));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public ImmutableSet<Pair<StandardId, Currency>> getCreditLegalEntities() {
        return this.creditCurveIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getCreditMarketDataIds(StandardId legalEntityId, Currency currency) {
        CurveId id = (CurveId)this.creditCurveIds.get((Object)Pair.of((Object)legalEntityId, (Object)currency));
        if (id == null) {
            throw new IllegalArgumentException(Messages.format((String)"Credit rates lookup has no credit curve defined for legal entity ID '{}' and currency '{}'", (Object[])new Object[]{legalEntityId, currency}));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public ImmutableSet<StandardId> getRecoveryRateLegalEntities() {
        return this.recoveryRateCurveIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getRecoveryRateMarketDataIds(StandardId legalEntityId) {
        CurveId id = (CurveId)this.recoveryRateCurveIds.get((Object)legalEntityId);
        if (id == null) {
            throw new IllegalArgumentException(Messages.format((String)"Credit rates lookup has no recovery rate curve defined for legal entity ID '{}'", (Object)legalEntityId));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(StandardId legalEntityId, Currency currency) {
        CurveId creditCurveId = (CurveId)this.creditCurveIds.get((Object)Pair.of((Object)legalEntityId, (Object)currency));
        if (creditCurveId == null) {
            throw new IllegalArgumentException(Messages.format((String)"Credit rates lookup has no credit curve defined for '{}' and '{}'", (Object[])new Object[]{legalEntityId, currency}));
        }
        CurveId discountCurveId = (CurveId)this.discountCurveIds.get((Object)currency);
        if (discountCurveId == null) {
            throw new IllegalArgumentException(Messages.format((String)"Credit rates lookup has no discount curve defined for '{}'", (Object)currency));
        }
        CurveId recoveryRateCurveId = (CurveId)this.recoveryRateCurveIds.get((Object)legalEntityId);
        if (recoveryRateCurveId == null) {
            throw new IllegalArgumentException(Messages.format((String)"Credit rates lookup has no recovery rate curve defined for '{}'", (Object)legalEntityId));
        }
        return FunctionRequirements.builder().valueRequirements((Set)ImmutableSet.of((Object)creditCurveId, (Object)discountCurveId, (Object)recoveryRateCurveId)).outputCurrencies(new Currency[]{currency}).observableSource(this.observableSource).build();
    }

    @Override
    public CreditRatesProvider creditRatesProvider(MarketData marketData) {
        return DefaultLookupCreditRatesProvider.of(this, marketData);
    }

    public static TypedMetaBean<DefaultCreditRatesMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultCreditRatesMarketDataLookup(Map<Pair<StandardId, Currency>, CurveId> creditCurveIds, Map<Currency, CurveId> discountCurveIds, Map<StandardId, CurveId> recoveryRateCurveIds, ObservableSource observableSource) {
        JodaBeanUtils.notNull(creditCurveIds, (String)"creditCurveIds");
        JodaBeanUtils.notNull(discountCurveIds, (String)"discountCurveIds");
        JodaBeanUtils.notNull(recoveryRateCurveIds, (String)"recoveryRateCurveIds");
        JodaBeanUtils.notNull((Object)observableSource, (String)"observableSource");
        this.creditCurveIds = ImmutableMap.copyOf(creditCurveIds);
        this.discountCurveIds = ImmutableMap.copyOf(discountCurveIds);
        this.recoveryRateCurveIds = ImmutableMap.copyOf(recoveryRateCurveIds);
        this.observableSource = observableSource;
    }

    public TypedMetaBean<DefaultCreditRatesMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<Pair<StandardId, Currency>, CurveId> getCreditCurveIds() {
        return this.creditCurveIds;
    }

    public ImmutableMap<Currency, CurveId> getDiscountCurveIds() {
        return this.discountCurveIds;
    }

    public ImmutableMap<StandardId, CurveId> getRecoveryRateCurveIds() {
        return this.recoveryRateCurveIds;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultCreditRatesMarketDataLookup other = (DefaultCreditRatesMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.creditCurveIds, other.creditCurveIds) && JodaBeanUtils.equal(this.discountCurveIds, other.discountCurveIds) && JodaBeanUtils.equal(this.recoveryRateCurveIds, other.recoveryRateCurveIds) && JodaBeanUtils.equal((Object)this.observableSource, (Object)other.observableSource);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.creditCurveIds);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.discountCurveIds);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.recoveryRateCurveIds);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableSource);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("DefaultCreditRatesMarketDataLookup{");
        buf.append("creditCurveIds").append('=').append(JodaBeanUtils.toString(this.creditCurveIds)).append(',').append(' ');
        buf.append("discountCurveIds").append('=').append(JodaBeanUtils.toString(this.discountCurveIds)).append(',').append(' ');
        buf.append("recoveryRateCurveIds").append('=').append(JodaBeanUtils.toString(this.recoveryRateCurveIds)).append(',').append(' ');
        buf.append("observableSource").append('=').append(JodaBeanUtils.toString((Object)this.observableSource));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

