/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.curve;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveGroup;
import com.opengamma.strata.market.curve.CurveGroupDefinition;
import com.opengamma.strata.market.curve.CurveId;

public class CurveMarketDataFunction
implements MarketDataFunction<Curve, CurveId> {
    public MarketDataRequirements requirements(CurveId id, MarketDataConfig config) {
        CurveGroupDefinition groupDefn = (CurveGroupDefinition)config.get(CurveGroupDefinition.class, (TypedString)id.getCurveGroupName());
        MarketDataId groupId = groupDefn.createGroupId(id.getObservableSource());
        return MarketDataRequirements.of((MarketDataId)groupId);
    }

    public MarketDataBox<Curve> build(CurveId id, MarketDataConfig config, ScenarioMarketData marketData, ReferenceData refData) {
        CurveGroupDefinition groupDefn = (CurveGroupDefinition)config.get(CurveGroupDefinition.class, (TypedString)id.getCurveGroupName());
        MarketDataId groupId = groupDefn.createGroupId(id.getObservableSource());
        MarketDataBox curveGroupBox = marketData.getValue(groupId);
        return curveGroupBox.map(curveGroup -> this.findCurve(id, (CurveGroup)curveGroup));
    }

    private Curve findCurve(CurveId id, CurveGroup curveGroup) {
        return (Curve)curveGroup.findCurve(id.getCurveName()).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"No curve found: {}", (Object)id.getCurveName())));
    }

    public Class<CurveId> getMarketDataIdType() {
        return CurveId.class;
    }
}

