/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fra;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.fra.FraMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.fra.DiscountingFraTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fra.ResolvedFraTrade;

public class FraTradeCalculations {
    public static final FraTradeCalculations DEFAULT = new FraTradeCalculations(DiscountingFraTradePricer.DEFAULT);
    private final FraMeasureCalculations calc;

    public FraTradeCalculations(DiscountingFraTradePricer tradePricer) {
        this.calc = new FraMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public ScenarioArray<ExplainMap> explainPresentValue(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.explainPresentValue(trade, lookup.marketDataView(marketData));
    }

    public ExplainMap explainPresentValue(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.explainPresentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parRate(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parRate(trade, lookup.marketDataView(marketData));
    }

    public double parRate(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.parRate(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.parSpread(trade, ratesProvider);
    }

    public ScenarioArray<CashFlows> cashFlows(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.cashFlows(trade, lookup.marketDataView(marketData));
    }

    public CashFlows cashFlows(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.cashFlows(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public CurrencyScenarioArray currentCash(ResolvedFraTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount currentCash(ResolvedFraTrade trade, RatesProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }
}

