/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.observable.QuoteId;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FxRateConfig
implements ImmutableBean {
    @PropertyDefinition(validate="notNull", get="private")
    private final ImmutableMap<CurrencyPair, QuoteId> observableRates;

    public Optional<QuoteId> getObservableRateKey(CurrencyPair currencyPair) {
        QuoteId quoteId = (QuoteId)this.observableRates.get((Object)currencyPair.toConventional());
        return Optional.ofNullable(quoteId);
    }

    public static FxRateConfig of(Map<CurrencyPair, QuoteId> quotesMap) {
        return new FxRateConfig(quotesMap);
    }

    @ImmutableValidator
    private void validate() {
        for (CurrencyPair currencyPair : this.observableRates.keySet()) {
            if (currencyPair.isConventional()) continue;
            throw new IllegalArgumentException(Messages.format((String)"Currency pairs must be quoted using market conventions but {} is not", (Object)currencyPair));
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FxRateConfig(Map<CurrencyPair, QuoteId> observableRates) {
        JodaBeanUtils.notNull(observableRates, (String)"observableRates");
        this.observableRates = ImmutableMap.copyOf(observableRates);
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    private ImmutableMap<CurrencyPair, QuoteId> getObservableRates() {
        return this.observableRates;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxRateConfig other = (FxRateConfig)obj;
            return JodaBeanUtils.equal(this.observableRates, other.observableRates);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.observableRates);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("FxRateConfig{");
        buf.append("observableRates").append('=').append(JodaBeanUtils.toString(this.observableRates));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FxRateConfig> {
        private Map<CurrencyPair, QuoteId> observableRates = ImmutableMap.of();

        private Builder() {
        }

        private Builder(FxRateConfig beanToCopy) {
            this.observableRates = beanToCopy.getObservableRates();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1996176400: {
                    return this.observableRates;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1996176400: {
                    this.observableRates = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FxRateConfig build() {
            return new FxRateConfig(this.observableRates);
        }

        public Builder observableRates(Map<CurrencyPair, QuoteId> observableRates) {
            JodaBeanUtils.notNull(observableRates, (String)"observableRates");
            this.observableRates = observableRates;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("FxRateConfig.Builder{");
            buf.append("observableRates").append('=').append(JodaBeanUtils.toString(this.observableRates));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<CurrencyPair, QuoteId>> observableRates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observableRates", FxRateConfig.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observableRates"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1996176400: {
                    return this.observableRates;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FxRateConfig> beanType() {
            return FxRateConfig.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<CurrencyPair, QuoteId>> observableRates() {
            return this.observableRates;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1996176400: {
                    return ((FxRateConfig)bean).getObservableRates();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

