/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.fx.DiscountingFxSingleTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.fx.ResolvedFxSingleTrade;

final class FxSingleMeasureCalculations {
    public static final FxSingleMeasureCalculations DEFAULT = new FxSingleMeasureCalculations(DiscountingFxSingleTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingFxSingleTradePricer tradePricer;

    FxSingleMeasureCalculations(DiscountingFxSingleTradePricer tradePricer) {
        this.tradePricer = (DiscountingFxSingleTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount presentValue(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.presentValue(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    DoubleScenarioArray parSpread(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parSpread(trade, marketData.scenario(i).ratesProvider()));
    }

    double parSpread(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.parSpread(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currencyExposure(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray currentCash(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currentCash(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currentCash(trade, ratesProvider);
    }

    ScenarioArray<FxRate> forwardFxRate(ResolvedFxSingleTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.forwardFxRate(trade, marketData.scenario(i).ratesProvider()));
    }

    FxRate forwardFxRate(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.forwardFxRate(trade, ratesProvider);
    }
}

